/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df;

import aero.t2s.modes.Track;
import aero.t2s.modes.decoder.Common;
import aero.t2s.modes.decoder.df.DownlinkFormat;

public class DF5
extends DownlinkFormat {
    private boolean alert;
    private boolean spi;
    private int modeA;

    public DF5(short[] data) {
        super(data, DownlinkFormat.IcaoAddress.FROM_PARITY);
    }

    @Override
    public DF5 decode() {
        int fs = this.data[0] & 7;
        this.alert = Common.isFlightStatusAlert(fs);
        this.spi = Common.isFlightStatusSpi(fs);
        this.modeA = Common.modeA((this.data[2] << 8 | this.data[3]) & 0x1FFF);
        return this;
    }

    @Override
    public void apply(Track track) {
        track.getFlightStatus().setAlert(this.alert);
        track.getFlightStatus().setSpi(this.spi);
        track.setModeA(this.modeA);
    }

    public boolean isAlert() {
        return this.alert;
    }

    public boolean isSpi() {
        return this.spi;
    }

    public int getModeA() {
        return this.modeA;
    }
}

