/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df.bds;

import aero.t2s.modes.Track;
import aero.t2s.modes.constants.SelectedAltitudeSource;
import aero.t2s.modes.decoder.df.bds.Bds;

public class Bds40
extends Bds {
    private boolean statusMcp;
    private boolean statusFms;
    private boolean statusBaro;
    private boolean statusMcpMode;
    private boolean statusTargetSource;
    private SelectedAltitudeSource selectedAltitudeSource;
    private int selectedAltitude;
    private int fmsAltitude;
    private double baro;
    private boolean autopilotVnav;
    private boolean autopilotAltitudeHold;
    private boolean autopilotApproach;

    public Bds40(short[] data) {
        super(data);
        boolean reservedZeroB;
        this.statusMcp = (data[4] & 0x80) != 0;
        this.statusFms = (data[5] & 4) != 0;
        this.statusBaro = (data[7] & 0x20) != 0;
        this.statusMcpMode = (data[9] & 1) != 0;
        this.statusTargetSource = (data[10] & 4) != 0;
        boolean reservedZeroA = (data[8] & 1 | data[9] >>> 1) == 0;
        boolean bl = reservedZeroB = (data[10] >>> 3 & 3) == 0;
        if (!reservedZeroA) {
            this.invalidate();
            return;
        }
        if (!reservedZeroB) {
            this.invalidate();
            return;
        }
        this.selectedAltitude = ((data[4] & 0x7F) << 5 | (data[5] & 0xF8) >>> 3) * 16;
        if (this.statusMcp) {
            if (this.selectedAltitude > 50000) {
                this.invalidate();
                return;
            }
        } else if (this.selectedAltitude != 0) {
            this.invalidate();
            return;
        }
        this.fmsAltitude = ((data[5] & 3) << 10 | data[6] << 2 | data[7] >>> 6 & 3) * 16;
        if (this.statusFms) {
            if (this.fmsAltitude <= 0 || this.fmsAltitude > 50000) {
                this.invalidate();
                return;
            }
        } else if (this.fmsAltitude != 0) {
            this.invalidate();
            return;
        }
        this.baro = (double)((data[7] & 0x1F) << 7 | data[8] >>> 1) * 0.1 + 800.0;
        if (this.statusBaro) {
            if (this.baro < 850.0 || this.baro > 1100.0) {
                this.invalidate();
                return;
            }
        } else if (this.baro != 800.0) {
            this.invalidate();
            return;
        }
        this.autopilotVnav = (data[10] & 0x80) != 0;
        this.autopilotAltitudeHold = (data[10] & 0x40) != 0;
        boolean bl2 = this.autopilotApproach = (data[10] & 0x20) != 0;
        if (!this.statusMcpMode && (this.autopilotAltitudeHold || this.autopilotVnav || this.autopilotApproach)) {
            this.invalidate();
            return;
        }
        int selectedSource = data[10] & 3;
        if (this.statusTargetSource) {
            this.selectedAltitudeSource = SelectedAltitudeSource.find(selectedSource);
        } else if (selectedSource != 0) {
            this.invalidate();
            return;
        }
    }

    @Override
    public void apply(Track track) {
        if (this.statusMcp) {
            track.setSelectedAltitude(this.selectedAltitude);
        }
        if (this.statusFms) {
            track.setFmsSelectedAltitude(this.fmsAltitude);
        }
        if (this.statusBaro) {
            track.setBaroSetting(this.baro);
        }
        if (this.statusMcpMode) {
            track.setVnav(this.autopilotVnav);
            track.setAltitudeHold(this.autopilotAltitudeHold);
            track.setApproachMode(this.autopilotApproach);
        }
        if (this.statusTargetSource) {
            track.setSelectedAltitudeSource(this.selectedAltitudeSource);
        }
    }

    @Override
    protected void reset() {
        this.statusMcp = false;
        this.statusFms = false;
        this.statusBaro = false;
        this.statusMcpMode = false;
        this.statusTargetSource = false;
        this.selectedAltitudeSource = null;
        this.selectedAltitude = 0;
        this.fmsAltitude = 0;
        this.baro = 0.0;
        this.autopilotVnav = false;
        this.autopilotAltitudeHold = false;
        this.autopilotApproach = false;
    }

    public boolean isStatusMcp() {
        return this.statusMcp;
    }

    public boolean isStatusFms() {
        return this.statusFms;
    }

    public boolean isStatusBaro() {
        return this.statusBaro;
    }

    public boolean isStatusMcpMode() {
        return this.statusMcpMode;
    }

    public boolean isStatusTargetSource() {
        return this.statusTargetSource;
    }

    public SelectedAltitudeSource getSelectedAltitudeSource() {
        return this.selectedAltitudeSource;
    }

    public int getSelectedAltitude() {
        return this.selectedAltitude;
    }

    public int getFmsAltitude() {
        return this.fmsAltitude;
    }

    public double getBaro() {
        return this.baro;
    }

    public boolean isAutopilotVnav() {
        return this.autopilotVnav;
    }

    public boolean isAutopilotAltitudeHold() {
        return this.autopilotAltitudeHold;
    }

    public boolean isAutopilotApproach() {
        return this.autopilotApproach;
    }
}

