/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df.df17;

import aero.t2s.modes.Track;
import aero.t2s.modes.constants.RocdSource;
import aero.t2s.modes.decoder.df.df17.AirborneVelocity;

public class AirborneVelocityGroundspeed
extends AirborneVelocity {
    private boolean xVelocityAvailable;
    private int xVelocity;
    private boolean yVelocityAvailable;
    private int yVelocity;

    public AirborneVelocityGroundspeed(short[] data) {
        super(data);
    }

    @Override
    public AirborneVelocityGroundspeed decode() {
        this.decodeCommonInformation();
        this.xVelocity = (this.data[5] & 3) << 8 | this.data[6];
        this.xVelocityAvailable = this.xVelocity != 0;
        this.xVelocity = (this.xVelocity - 1) * (this.isSupersonic() ? 4 : 1);
        if ((this.data[5] & 4) != 0) {
            this.xVelocity *= -1;
        }
        this.yVelocity = (this.data[7] & 0x7F) << 3 | (this.data[8] & 0xE0) >>> 5;
        this.yVelocityAvailable = this.yVelocity != 0;
        this.yVelocity = (this.yVelocity - 1) * (this.isSupersonic() ? 4 : 1);
        if ((this.data[7] & 0x80) != 0) {
            this.yVelocity *= -1;
        }
        return this;
    }

    @Override
    public void apply(Track track) {
        track.setNACv(this.NACv.ordinal());
        if (this.isGnssAltitudeDifferenceFromBaroAvailable()) {
            track.setGeometricHeightOffset(this.getGnssAltitudeDifferenceFromBaro());
        }
        if (this.isRocdAvailable()) {
            track.setRocdAvailable(true);
            track.setRocdSourceBaro(this.getRocdSource() == RocdSource.BARO);
            if (this.getRocdSource() == RocdSource.BARO) {
                track.setBaroRocd(this.getRocd());
            } else {
                track.setRocd(this.getRocd());
            }
        }
        if (this.xVelocityAvailable) {
            track.setVx(this.xVelocity);
        }
        if (this.yVelocityAvailable) {
            track.setVy(this.yVelocity);
        }
        if (this.xVelocityAvailable && this.yVelocityAvailable) {
            track.setGs(Math.sqrt(this.xVelocity * this.xVelocity + this.yVelocity * this.yVelocity));
        }
    }
}

