/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df.df17;

import aero.t2s.modes.Track;
import aero.t2s.modes.constants.AcasCapability;
import aero.t2s.modes.constants.Angle;
import aero.t2s.modes.constants.BarometricAltitudeIntegrityCode;
import aero.t2s.modes.constants.EmergencyState;
import aero.t2s.modes.constants.HorizontalDataAvailable;
import aero.t2s.modes.constants.HorizontalModeIndicator;
import aero.t2s.modes.constants.NavigationAccuracyCategoryPosition;
import aero.t2s.modes.constants.SourceIntegrityLevel;
import aero.t2s.modes.constants.TargetAltitudeCapability;
import aero.t2s.modes.constants.TargetAltitudeType;
import aero.t2s.modes.constants.VerticalDataAvailable;
import aero.t2s.modes.constants.VerticalModeIndicator;
import aero.t2s.modes.decoder.df.df17.TargetStatusMessage;

public class TargetStatusMessageType0
extends TargetStatusMessage {
    private int subType = 0;
    private VerticalDataAvailable verticalDataAvailable;
    private TargetAltitudeType targetAltitudeType;
    private TargetAltitudeCapability targetAltitudeCapability;
    private VerticalModeIndicator verticalModeIndicator;
    private int targetAltitude;
    private HorizontalDataAvailable horizontalDataAvailable;
    private int targetHeadingTrack;
    private Angle targetAngle;
    private HorizontalModeIndicator horizontalModeIndicator;
    private NavigationAccuracyCategoryPosition NACp;
    private BarometricAltitudeIntegrityCode NICbaro;
    private SourceIntegrityLevel sil;
    private AcasCapability acasCapability;
    private EmergencyState emergency;

    public TargetStatusMessageType0(short[] data) {
        super(data);
    }

    @Override
    public TargetStatusMessageType0 decode() {
        this.verticalDataAvailable = VerticalDataAvailable.from((this.data[4] & 1) << 1 | this.data[5] >>> 7);
        this.targetAltitudeType = TargetAltitudeType.from((this.data[5] & 0x40) >>> 6);
        this.targetAltitudeCapability = TargetAltitudeCapability.from((this.data[5] & 0x18) >>> 3);
        this.verticalModeIndicator = VerticalModeIndicator.from((this.data[5] & 6) >>> 1);
        int targetAltitudeValue = (this.data[5] & 1) << 9 | this.data[6] << 1 | (this.data[7] & 0x80) >>> 7;
        if (targetAltitudeValue < 1011) {
            if (targetAltitudeValue >= 11) {
                --targetAltitudeValue;
            }
            this.targetAltitude = (-10 + targetAltitudeValue) * 1000;
        }
        this.horizontalDataAvailable = HorizontalDataAvailable.from((this.data[7] & 0x60) >>> 5);
        this.targetHeadingTrack = (this.data[7] & 0x1F) << 4 | this.data[8] & 0xF0;
        this.targetAngle = (this.data[8] & 8) != 0 ? Angle.TRACK : Angle.HEADING;
        this.horizontalModeIndicator = HorizontalModeIndicator.from((this.data[8] & 6) >>> 1);
        this.NACp = NavigationAccuracyCategoryPosition.find((this.data[8] & 1) << 3 | (this.data[9] & 0xE0) >>> 5);
        this.NICbaro = BarometricAltitudeIntegrityCode.from((this.data[9] & 0x10) >>> 4);
        this.sil = SourceIntegrityLevel.from((this.data[9] & 0xC) >>> 2);
        this.acasCapability = AcasCapability.from((this.data[10] & 0x18) >>> 3);
        this.emergency = EmergencyState.from(this.data[10] & 7);
        return this;
    }

    @Override
    public void apply(Track track) {
        track.setNACp(this.NACp);
        if (this.horizontalDataAvailable != HorizontalDataAvailable.NOT_VALID) {
            track.setSelectedHeading(this.targetHeadingTrack);
        }
        if (this.verticalDataAvailable != VerticalDataAvailable.NOT_VALID) {
            track.setSelectedAltitude(this.targetAltitude);
        }
        track.setEmergencyState(this.emergency);
        track.setSil(this.sil.ordinal());
    }

    public int getSubType() {
        return this.subType;
    }

    public boolean isTargetHeadingTrackValid() {
        return this.targetHeadingTrack >= 360;
    }

    public VerticalDataAvailable getVerticalDataAvailable() {
        return this.verticalDataAvailable;
    }

    public TargetAltitudeType getTargetAltitudeType() {
        return this.targetAltitudeType;
    }

    public TargetAltitudeCapability getTargetAltitudeCapability() {
        return this.targetAltitudeCapability;
    }

    public VerticalModeIndicator getVerticalModeIndicator() {
        return this.verticalModeIndicator;
    }

    public int getTargetAltitude() {
        return this.targetAltitude;
    }

    public HorizontalDataAvailable getHorizontalDataAvailable() {
        return this.horizontalDataAvailable;
    }

    public int getTargetHeadingTrack() {
        return this.targetHeadingTrack;
    }

    public Angle getTargetAngle() {
        return this.targetAngle;
    }

    public HorizontalModeIndicator getHorizontalModeIndicator() {
        return this.horizontalModeIndicator;
    }

    public NavigationAccuracyCategoryPosition getNACp() {
        return this.NACp;
    }

    public BarometricAltitudeIntegrityCode getNICbaro() {
        return this.NICbaro;
    }

    public SourceIntegrityLevel getSil() {
        return this.sil;
    }

    public AcasCapability getAcasCapability() {
        return this.acasCapability;
    }

    public EmergencyState getEmergency() {
        return this.emergency;
    }
}

