/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df.df17.data;

import aero.t2s.modes.constants.AcasState;
import aero.t2s.modes.constants.SourceIntegrityLevel;

public class AirborneOperationalMode {
    private AcasState acasRA;
    private boolean acasIdent;
    private boolean singleAntennaFlag;
    private SourceIntegrityLevel systemDesignAssurance;

    public AirborneOperationalMode(int data) {
        this.acasRA = (data & 0x2000) != 0 ? AcasState.RA_ACTIVE : AcasState.RA_NOT_ACTIVE;
        this.acasIdent = (data & 0x1000) != 0;
        this.singleAntennaFlag = (data & 0x400) != 0;
        this.systemDesignAssurance = SourceIntegrityLevel.from((data & 0x300) >>> 8);
    }

    public AcasState getAcasRA() {
        return this.acasRA;
    }

    public boolean isAcasIdent() {
        return this.acasIdent;
    }

    public boolean isSingleAntennaFlag() {
        return this.singleAntennaFlag;
    }

    public SourceIntegrityLevel getSystemDesignAssurance() {
        return this.systemDesignAssurance;
    }
}

