/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df;

import aero.t2s.modes.Acas;
import aero.t2s.modes.Altitude;
import aero.t2s.modes.Track;
import aero.t2s.modes.constants.AcasReplyInformation;
import aero.t2s.modes.constants.AcasSensitivity;
import aero.t2s.modes.constants.CrossLinkCapability;
import aero.t2s.modes.constants.ResolutionAdvisory;
import aero.t2s.modes.constants.VerticalStatus;
import aero.t2s.modes.decoder.AltitudeEncoding;
import aero.t2s.modes.decoder.df.DownlinkFormat;

public class DF16
extends DownlinkFormat {
    private VerticalStatus verticalStatus;
    private CrossLinkCapability crossLinkCapability;
    private AcasSensitivity sensitivity;
    private AcasReplyInformation replyInformation;
    private Altitude altitude;
    private ResolutionAdvisory resolutionAdvisory;
    private boolean multipleThreats;
    private boolean RANotPassBelow;
    private boolean RANotPassAbove;
    private boolean RANotTurnLeft;
    private boolean RANotTurnRight;

    public DF16(short[] data) {
        super(data, DownlinkFormat.IcaoAddress.FROM_PARITY);
    }

    @Override
    public DF16 decode() {
        this.verticalStatus = VerticalStatus.from(this.data[0] >>> 2 & 1);
        this.crossLinkCapability = CrossLinkCapability.from(this.data[0] >>> 1 & 1);
        this.sensitivity = AcasSensitivity.from(this.data[1] >>> 5);
        this.replyInformation = AcasReplyInformation.from((this.data[1] & 7) << 1 | this.data[2] >> 7 & 1);
        this.altitude = AltitudeEncoding.decode((this.data[2] << 8 | this.data[3]) & 0x1FFF);
        int vds1 = this.data[4] >>> 4;
        int vds2 = this.data[4] & 0xF;
        int ara = this.data[5] << 5 | this.data[6] >>> 3;
        int rac = (this.data[5] & 3) << 2 | this.data[6] >>> 6;
        int rat = this.data[6] >>> 5 & 1;
        boolean bl = this.multipleThreats = (this.data[6] >>> 4 & 1) == 1;
        if (vds1 == 3 && vds2 == 0) {
            this.resolutionAdvisory = new ResolutionAdvisory(ara);
            this.RANotPassBelow = rac >>> 3 == 1;
            this.RANotPassAbove = (rac >>> 2 & 1) == 1;
            this.RANotTurnLeft = (rac >>> 1 & 1) == 1;
            boolean bl2 = this.RANotTurnLeft = (rac & 1) == 1;
        }
        if (rat == 1 || this.resolutionAdvisory == null) {
            this.resolutionAdvisory = new ResolutionAdvisory();
            this.RANotPassBelow = false;
            this.RANotPassAbove = false;
            this.RANotTurnLeft = false;
            this.RANotTurnRight = false;
            this.multipleThreats = false;
        }
        return this;
    }

    @Override
    public void apply(Track track) {
        Acas acas = track.getAcas();
        acas.setVerticalStatus(this.verticalStatus);
        acas.setCrossLinkCapability(this.crossLinkCapability);
        acas.setSensitivity(this.sensitivity);
        acas.setReplyInformation(this.replyInformation);
        acas.setAltitude(this.altitude);
        acas.getResolutionAdvisory().update(this.resolutionAdvisory);
        acas.setRANotPassBelow(this.RANotPassBelow);
        acas.setRANotPassAbove(this.RANotPassAbove);
        acas.setRANotTurnLeft(this.RANotTurnLeft);
        acas.setRANotTurnRight(this.RANotTurnRight);
        acas.setMultipleThreats(this.multipleThreats);
    }

    public VerticalStatus getVerticalStatus() {
        return this.verticalStatus;
    }

    public CrossLinkCapability getCrossLinkCapability() {
        return this.crossLinkCapability;
    }

    public AcasSensitivity getSensitivity() {
        return this.sensitivity;
    }

    public AcasReplyInformation getReplyInformation() {
        return this.replyInformation;
    }

    public Altitude getAltitude() {
        return this.altitude;
    }

    public ResolutionAdvisory getResolutionAdvisory() {
        return this.resolutionAdvisory;
    }

    public boolean isMultipleThreats() {
        return this.multipleThreats;
    }

    public boolean isRANotPassBelow() {
        return this.RANotPassBelow;
    }

    public boolean isRANotPassAbove() {
        return this.RANotPassAbove;
    }

    public boolean isRANotTurnLeft() {
        return this.RANotTurnLeft;
    }

    public boolean isRANotTurnRight() {
        return this.RANotTurnRight;
    }
}

