/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df;

import aero.t2s.modes.Altitude;
import aero.t2s.modes.Track;
import aero.t2s.modes.decoder.AltitudeEncoding;
import aero.t2s.modes.decoder.Common;
import aero.t2s.modes.decoder.df.DownlinkFormat;

public class DF4
extends DownlinkFormat {
    private boolean alert;
    private boolean spi;
    private Altitude altitude;

    public DF4(short[] data) {
        super(data, DownlinkFormat.IcaoAddress.FROM_PARITY);
    }

    @Override
    public DF4 decode() {
        int fs = this.data[0] & 7;
        this.alert = Common.isFlightStatusAlert(fs);
        this.spi = Common.isFlightStatusSpi(fs);
        this.altitude = AltitudeEncoding.decode((this.data[2] << 8 | this.data[3]) & 0x1FFF);
        return this;
    }

    @Override
    public void apply(Track track) {
        track.getFlightStatus().setAlert(this.alert);
        track.getFlightStatus().setSpi(this.spi);
        track.setAltitude(this.altitude);
    }

    public boolean isAlert() {
        return this.alert;
    }

    public boolean isSpi() {
        return this.spi;
    }

    public Altitude getAltitude() {
        return this.altitude;
    }
}

