/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df.bds;

import aero.t2s.modes.Track;
import aero.t2s.modes.decoder.Common;
import aero.t2s.modes.decoder.df.bds.Bds;

public class Bds21
extends Bds {
    private boolean statusAircraftRegistration;
    private boolean statusAirlineRegistration;
    private String registration;
    private String airline;

    public Bds21(short[] data) {
        super(data);
        this.statusAircraftRegistration = (data[4] & 0x80) != 0;
        boolean bl = this.statusAirlineRegistration = (data[9] & 0x10) != 0;
        if (!this.statusAircraftRegistration && (data[4] | data[5] | data[6] | data[7] | data[8] | data[9] >>> 5) != 0) {
            this.invalidate();
            return;
        }
        if (!this.statusAirlineRegistration && (data[9] & 0xF | data[10]) != 0) {
            this.invalidate();
            return;
        }
        if (data[4] != 32) {
            this.invalidate();
            return;
        }
        if (this.statusAircraftRegistration) {
            this.registration = Common.charToString((data[4] & 0x7E) >>> 1) + Common.charToString((data[4] & 1) << 5 | data[5] >>> 3) + Common.charToString((data[5] & 7) << 3 | data[6] >>> 5) + Common.charToString((data[6] & 0x1F) << 1 | data[7] >>> 7) + Common.charToString((data[7] & 0x7E) >>> 1) + Common.charToString((data[7] & 1) << 5 | data[8] >>> 3) + Common.charToString((data[8] & 7) << 3 | data[9] >>> 3);
            if (this.registration.contains("#")) {
                this.invalidate();
                return;
            }
            this.registration = this.registration.replace("_", "");
        }
        if (this.statusAirlineRegistration) {
            this.airline = Common.charToString((data[9] & 0xF) << 2 | data[10] >>> 6) + Common.charToString(data[10] & 0x3F);
            if (this.airline.contains("_") || this.airline.contains("#")) {
                this.invalidate();
                return;
            }
        }
    }

    @Override
    public void apply(Track track) {
        if (this.statusAircraftRegistration) {
            track.setRegistration(this.registration);
        }
        if (this.statusAirlineRegistration) {
            track.setOperator(this.airline);
        }
    }

    @Override
    protected void reset() {
        this.statusAircraftRegistration = false;
        this.statusAirlineRegistration = false;
        this.registration = null;
        this.airline = null;
    }

    public boolean isStatusAircraftRegistration() {
        return this.statusAircraftRegistration;
    }

    public boolean isStatusAirlineRegistration() {
        return this.statusAirlineRegistration;
    }

    public String getRegistration() {
        return this.registration;
    }

    public String getAirline() {
        return this.airline;
    }
}

