/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df.bds;

import aero.t2s.modes.Meteo;
import aero.t2s.modes.Track;
import aero.t2s.modes.constants.Hazard;
import aero.t2s.modes.decoder.df.bds.Bds;

public class Bds45
extends Bds {
    private static final double SAT_ACCURACY = 0.25;
    private static final int RADIO_HEIGHT_ACCURACY = 16;
    private boolean statusTurbulence;
    private boolean statusWindShear;
    private boolean statusMicroBurst;
    private boolean statusIcing;
    private boolean statusWake;
    private boolean statusSat;
    private boolean statusAverageStaticPressure;
    private boolean statusRadioHeight;
    private Hazard turbulence;
    private Hazard windShear;
    private Hazard microBurst;
    private Hazard icing;
    private Hazard wake;
    private double sat;
    private int averageStaticPressure;
    private int radioHeight;

    public Bds45(short[] data) {
        super(data);
        this.statusTurbulence = data[4] >>> 7 == 1;
        this.statusWindShear = (data[4] & 0x10) >>> 4 == 1;
        this.statusMicroBurst = (data[4] & 2) >>> 1 == 1;
        this.statusIcing = (data[5] & 0x40) >>> 6 == 1;
        this.statusWake = (data[5] & 8) >>> 3 == 1;
        this.statusSat = (data[5] & 1) == 1;
        this.statusAverageStaticPressure = (data[7] & 0x20) >>> 5 == 1;
        boolean bl = this.statusRadioHeight = (data[8] & 2) >>> 1 == 1;
        if ((data[10] & 0x1F) != 0) {
            this.invalidate();
            return;
        }
        if (!(this.statusTurbulence || this.statusWindShear || this.statusMicroBurst || this.statusIcing || this.statusWake || this.statusSat || this.statusAverageStaticPressure || this.statusRadioHeight)) {
            this.invalidate();
            return;
        }
        this.turbulence = Hazard.find((data[4] & 0x60) >>> 5);
        if (!this.statusTurbulence && this.turbulence != Hazard.NIL) {
            this.invalidate();
            return;
        }
        this.windShear = Hazard.find((data[4] & 0xC) >>> 2);
        if (!this.statusWindShear && this.windShear != Hazard.NIL) {
            this.invalidate();
            return;
        }
        this.microBurst = Hazard.find((data[4] & 1) << 1 | data[5] >> 7);
        if (!this.statusMicroBurst && this.microBurst != Hazard.NIL) {
            this.invalidate();
            return;
        }
        this.icing = Hazard.find((data[5] & 0x30) >>> 4);
        if (!this.statusIcing && this.icing != Hazard.NIL) {
            this.invalidate();
            return;
        }
        this.wake = Hazard.find((data[5] & 6) >>> 1);
        if (!this.statusWake && this.wake != Hazard.NIL) {
            this.invalidate();
            return;
        }
        boolean isSatNegative = data[6] >>> 7 == 1;
        this.sat = (double)((data[6] & 0x7F) << 2 | data[7] >>> 6) * 0.25 * (double)(isSatNegative ? -1 : 1);
        if (!this.statusSat && this.sat != 0.0) {
            this.invalidate();
            return;
        }
        if (this.statusSat && (this.sat > 60.0 || this.sat < -80.0)) {
            this.invalidate();
            return;
        }
        this.averageStaticPressure = (data[7] & 0x1F) << 6 | data[8] >>> 2;
        if (!this.statusAverageStaticPressure && this.averageStaticPressure != 0) {
            this.invalidate();
            return;
        }
        if (this.statusAverageStaticPressure && this.averageStaticPressure >= 1050) {
            this.invalidate();
            return;
        }
        this.radioHeight = ((data[8] & 1) << 11 | data[9] << 3 | data[10] >>> 5) * 16;
        if (!this.statusRadioHeight && this.radioHeight != 0) {
            this.invalidate();
            return;
        }
    }

    @Override
    public void apply(Track track) {
        Meteo meteo = track.getMeteo();
        if (this.statusTurbulence) {
            meteo.setTurbulence(this.turbulence);
        }
        if (this.statusWindShear) {
            meteo.setWindShear(this.windShear);
        }
        if (this.statusMicroBurst) {
            meteo.setMicroBurst(this.microBurst);
        }
        if (this.statusIcing) {
            meteo.setIcing(this.icing);
        }
        if (this.statusWake) {
            meteo.setWake(this.wake);
        }
        if (this.statusSat) {
            meteo.setStaticAirTemperature(this.sat);
        }
        if (this.statusAverageStaticPressure) {
            meteo.setAverageStaticPressure(this.averageStaticPressure);
        }
        if (this.statusRadioHeight) {
            meteo.setRadioHeight(this.radioHeight);
        }
    }

    @Override
    protected void reset() {
        this.statusTurbulence = false;
        this.statusWindShear = false;
        this.statusMicroBurst = false;
        this.statusIcing = false;
        this.statusWake = false;
        this.statusSat = false;
        this.statusAverageStaticPressure = false;
        this.statusRadioHeight = false;
        this.turbulence = null;
        this.windShear = null;
        this.microBurst = null;
        this.icing = null;
        this.wake = null;
        this.sat = 0.0;
        this.averageStaticPressure = 0;
        this.radioHeight = 0;
    }

    public boolean isStatusTurbulence() {
        return this.statusTurbulence;
    }

    public boolean isStatusWindShear() {
        return this.statusWindShear;
    }

    public boolean isStatusMicroBurst() {
        return this.statusMicroBurst;
    }

    public boolean isStatusIcing() {
        return this.statusIcing;
    }

    public boolean isStatusWake() {
        return this.statusWake;
    }

    public boolean isStatusSat() {
        return this.statusSat;
    }

    public boolean isStatusAverageStaticPressure() {
        return this.statusAverageStaticPressure;
    }

    public boolean isStatusRadioHeight() {
        return this.statusRadioHeight;
    }

    public Hazard getTurbulence() {
        return this.turbulence;
    }

    public Hazard getWindShear() {
        return this.windShear;
    }

    public Hazard getMicroBurst() {
        return this.microBurst;
    }

    public Hazard getIcing() {
        return this.icing;
    }

    public Hazard getWake() {
        return this.wake;
    }

    public double getSat() {
        return this.sat;
    }

    public int getAverageStaticPressure() {
        return this.averageStaticPressure;
    }

    public int getRadioHeight() {
        return this.radioHeight;
    }
}

