/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df.bds;

import aero.t2s.modes.Track;
import aero.t2s.modes.decoder.df.bds.Bds;

public class Bds50
extends Bds {
    private static final double ROLL_ACCURACY = 0.17578125;
    private static final double TRUE_TRACK_ANGLE_ACCURACY = 0.17578125;
    private static final double SPEED_ACCURACY = 2.0;
    private static final double TRUE_TRACK_RATE_ACCURACY = 0.03125;
    private boolean statusRollAngle;
    private boolean statusTrackAngle;
    private boolean statusGs;
    private boolean statusTrueAngleRate;
    private boolean statusTas;
    private double gs;
    private double trackAngleRate;
    private double trueTrack;
    private double tas;
    private double rollAngle;

    public Bds50(short[] data) {
        super(data);
        this.statusRollAngle = (data[4] >>> 7 & 1) == 1;
        this.statusTrackAngle = (data[5] >>> 4 & 1) == 1;
        this.statusGs = (data[6] & 1) == 1;
        this.statusTrueAngleRate = (data[8] >>> 5 & 1) == 1;
        this.statusTas = (data[9] >>> 2 & 1) == 1;
        boolean isLeftWingDown = (data[4] >>> 6 & 1) == 1;
        this.rollAngle = (double)(((data[4] & 0x3F) << 3 | data[5] >>> 5) - (isLeftWingDown ? 512 : 0)) * 0.17578125;
        if (!this.statusRollAngle && (isLeftWingDown || this.rollAngle != 0.0)) {
            this.invalidate();
            return;
        }
        if (this.statusRollAngle) {
            if (Math.abs(this.rollAngle) > 50.0) {
                this.invalidate();
                this.rollAngle = 0.0;
                return;
            }
        } else {
            this.rollAngle = 0.0;
        }
        boolean isWest = (data[5] & 8) != 0;
        this.trueTrack = (data[5] & 7) << 7 | data[6] >>> 1;
        if (!this.statusTrackAngle && (isWest || this.trueTrack != 0.0)) {
            this.invalidate();
            return;
        }
        this.trueTrack = this.trueTrack * 0.17578125 + (isWest ? 180.0 : 0.0);
        this.gs = (double)(data[7] << 2 | data[8] >>> 6 & 3) * 2.0;
        if (this.statusGs) {
            if (this.gs > 600.0) {
                this.invalidate();
                return;
            }
        } else if (this.gs != 0.0) {
            this.invalidate();
            return;
        }
        boolean isTrackAngleRateNegative = (data[8] & 0x10) != 0;
        this.trackAngleRate = (data[8] & 0xF) << 5 | data[9] >>> 3;
        if (!this.statusTrueAngleRate && (isTrackAngleRateNegative || this.trackAngleRate != 0.0)) {
            this.invalidate();
            return;
        }
        if (this.statusTrueAngleRate && this.trackAngleRate == 255.0) {
            this.invalidate();
            return;
        }
        this.trackAngleRate = (this.trackAngleRate + (isTrackAngleRateNegative ? -512.0 : 0.0)) * 0.03125;
        this.tas = (double)((data[9] & 3) << 8 | data[10]) * 2.0;
        if (!this.statusTas && this.tas != 0.0) {
            this.invalidate();
            return;
        }
        if (this.statusGs && this.statusTas && Math.abs(this.tas - this.gs) > 200.0) {
            this.invalidate();
            return;
        }
    }

    @Override
    public void apply(Track track) {
        if (this.statusRollAngle) {
            track.setRollAngle(this.rollAngle);
        }
        if (this.statusTrackAngle) {
            track.setTrueHeading(this.trueTrack);
        }
        if (this.statusGs) {
            track.setGs(this.gs);
        }
        if (this.statusTrueAngleRate) {
            track.setTrackAngleRate(this.trackAngleRate);
        }
        if (this.statusTas) {
            track.setTas(this.tas);
        }
    }

    @Override
    protected void reset() {
        this.statusRollAngle = false;
        this.statusTrackAngle = false;
        this.statusGs = false;
        this.statusTrueAngleRate = false;
        this.statusTas = false;
        this.gs = 0.0;
        this.trackAngleRate = 0.0;
        this.trueTrack = 0.0;
        this.tas = 0.0;
        this.rollAngle = 0.0;
    }

    public boolean isStatusRollAngle() {
        return this.statusRollAngle;
    }

    public boolean isStatusTrackAngle() {
        return this.statusTrackAngle;
    }

    public boolean isStatusGs() {
        return this.statusGs;
    }

    public boolean isStatusTrueAngleRate() {
        return this.statusTrueAngleRate;
    }

    public boolean isStatusTas() {
        return this.statusTas;
    }

    public double getGs() {
        return this.gs;
    }

    public double getTrackAngleRate() {
        return this.trackAngleRate;
    }

    public double getTrueTrack() {
        return this.trueTrack;
    }

    public double getTas() {
        return this.tas;
    }

    public double getRollAngle() {
        return this.rollAngle;
    }
}

