/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df.df17;

import aero.t2s.modes.Track;
import aero.t2s.modes.constants.Angle;
import aero.t2s.modes.constants.BarometricAltitudeIntegrityCode;
import aero.t2s.modes.constants.NavigationIntegrityCategory;
import aero.t2s.modes.constants.SourceIntegrityLevel;
import aero.t2s.modes.constants.Version;
import aero.t2s.modes.decoder.df.df17.AircraftOperationalStatusVersion1;
import aero.t2s.modes.decoder.df.df17.data.AirborneCapability;
import aero.t2s.modes.decoder.df.df17.data.AirborneOperationalMode;

public class AircraftOperationalStatusVersion1Airborne
extends AircraftOperationalStatusVersion1 {
    private int subType = 0;
    private Version version = Version.VERSION1;
    private AirborneCapability capability;
    private AirborneOperationalMode operationalMode;
    private NavigationIntegrityCategory NICp;
    private SourceIntegrityLevel SIL;
    private BarometricAltitudeIntegrityCode NICbaro;
    private Angle horizontalSource;

    public AircraftOperationalStatusVersion1Airborne(short[] data) {
        super(data);
    }

    @Override
    public AircraftOperationalStatusVersion1Airborne decode() {
        this.capability = new AirborneCapability(this.data[5] << 8 | this.data[6], this.version);
        this.operationalMode = new AirborneOperationalMode(this.data[7] << 8 | this.data[8]);
        int NICsupp = (this.data[9] & 0x10) >>> 4;
        int NACp = this.data[9] & 0xF;
        this.NICp = NavigationIntegrityCategory.airborne(NACp, NICsupp, 0);
        this.SIL = SourceIntegrityLevel.from((this.data[10] & 0x30) >>> 4);
        this.NICbaro = BarometricAltitudeIntegrityCode.from((this.data[10] & 8) >>> 3);
        this.horizontalSource = (this.data[10] & 4) != 0 ? Angle.TRUE_HEADING : Angle.MAGNETIC_HEADING;
        return this;
    }

    @Override
    public void apply(Track track) {
        track.setVersion(this.version);
    }

    public int getSubType() {
        return this.subType;
    }

    public Version getVersion() {
        return this.version;
    }

    public AirborneCapability getCapability() {
        return this.capability;
    }

    public AirborneOperationalMode getOperationalMode() {
        return this.operationalMode;
    }

    public NavigationIntegrityCategory getNICp() {
        return this.NICp;
    }

    public SourceIntegrityLevel getSIL() {
        return this.SIL;
    }

    public BarometricAltitudeIntegrityCode getNICbaro() {
        return this.NICbaro;
    }

    public Angle getHorizontalSource() {
        return this.horizontalSource;
    }
}

