/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes;

import aero.t2s.modes.ModeSHandler;
import aero.t2s.modes.ModeSListener;
import aero.t2s.modes.ModeSTrackHandler;
import aero.t2s.modes.Track;
import aero.t2s.modes.database.ModeSDatabase;
import aero.t2s.modes.decoder.df.DownlinkFormat;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class ModeS {
    private final ModeSListener listener;
    private final Map<String, Track> tracks = new ConcurrentHashMap<String, Track>();
    private final ModeSHandler handler;
    private Consumer<Track> onTrackDeleted;
    private Consumer<Track> onTrackUpdated;
    private Consumer<Track> onTrackCreated;
    private Consumer<DownlinkFormat> onMessage;

    public ModeS(String host, int port, double originLat, double originLon) {
        this(host, port, originLat, originLon, null);
    }

    public ModeS(String host, int port, double originLat, double originLon, ModeSDatabase database) {
        this.onTrackDeleted = track -> {};
        this.onTrackUpdated = track -> {};
        this.onTrackCreated = track -> {};
        this.handler = new ModeSTrackHandler(this.tracks, originLat, originLon, database);
        this.handler.onTrackCreated(this.onTrackCreated);
        this.handler.onTrackCreated(this.onTrackUpdated);
        this.handler.onTrackCreated(this.onTrackDeleted);
        this.handler.onMessage(this.onMessage);
        this.listener = new ModeSListener(new InetSocketAddress(host, port), this.handler);
    }

    public ModeS(String host, int port, ModeSHandler handler) {
        this.onTrackDeleted = track -> {};
        this.onTrackUpdated = track -> {};
        this.onTrackCreated = track -> {};
        this.handler = handler;
        this.listener = new ModeSListener(new InetSocketAddress(host, port), handler);
    }

    public void onTrackDeleted(Consumer<Track> consumer) {
        this.handler.onTrackDeleted(consumer);
    }

    public void onTrackCreated(Consumer<Track> consumer) {
        this.handler.onTrackCreated(consumer);
    }

    public void onTrackUpdated(Consumer<Track> consumer) {
        this.handler.onTrackUpdated(consumer);
    }

    public void onMessage(Consumer<DownlinkFormat> consumer) {
        this.handler.onMessage(consumer);
    }

    public void start() {
        this.handler.start();
        this.listener.start();
    }

    public void stop() {
        this.listener.interrupt();
        this.handler.stop();
    }

    public Map<String, Track> getTracks() {
        return this.tracks;
    }
}

