/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.database;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class AircraftTypeDatabase {
    private Map<String, Aircraft> aircraft = new HashMap<String, Aircraft>();

    public AircraftTypeDatabase() {
    }

    public AircraftTypeDatabase(Path csvFile) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(csvFile.toUri().toURL().openStream()));){
            if (reader.ready()) {
                reader.readLine();
            }
            while (reader.ready()) {
                String line = reader.readLine().replace("\"", "");
                String[] parts = line.split(",");
                if (parts.length < 8) continue;
                this.aircraft.put(parts[2], new Aircraft(parts[2], parts[7]));
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("[ADS-B] Failed to read aircraft database", (Throwable)e);
        }
        LoggerFactory.getLogger(this.getClass()).info("[ADS-B] Aircraft database loaded {} aircraft", (Object)this.aircraft.size());
    }

    public Aircraft find(String icao) {
        return this.aircraft.get(icao);
    }

    public static class Aircraft {
        public String icao;
        public String wtc;

        public Aircraft(String icao, String wtc) {
            this.icao = icao;
            this.wtc = wtc;
        }
    }
}

