/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df.bds;

import aero.t2s.modes.Track;
import aero.t2s.modes.decoder.AltitudeEncoding;
import aero.t2s.modes.decoder.df.bds.Bds;

public class Bds60
extends Bds {
    private static final double MAG_ACCURACY = 0.17578125;
    private static final double MACH_ACCURACY = 4.0;
    private static final double ROCD_ACCURCY = 32.0;
    private boolean statusMagneticHeading;
    private boolean statusIas;
    private boolean statusMach;
    private boolean statusBaroRocd;
    private boolean statusIrsRocd;
    private double mach;
    private double magneticHeading;
    private int ias;
    private double baroRocd;
    private double irsRocd;

    public Bds60(short[] data) {
        super(data);
        double cas;
        double altitude;
        this.statusMagneticHeading = (data[4] & 0x80) != 0;
        this.statusIas = (data[5] & 8) != 0;
        this.statusMach = (data[6] & 1) != 0;
        this.statusBaroRocd = (data[8] & 0x20) != 0;
        boolean bl = this.statusIrsRocd = (data[9] & 4) != 0;
        if (!(this.statusMagneticHeading || this.statusIas || this.statusMach || this.statusBaroRocd || this.statusIrsRocd)) {
            this.invalidate();
            return;
        }
        double hdgSign = (data[4] >>> 6 & 1) == 1 ? -1024.0 : 0.0;
        this.magneticHeading = ((double)((data[4] & 0x3F) << 4 | data[5] >>> 4) + hdgSign) * 0.17578125;
        if (this.magneticHeading < 0.0) {
            this.magneticHeading += 360.0;
        }
        if (this.statusMagneticHeading) {
            if (this.magneticHeading < 0.0 || this.magneticHeading > 360.0) {
                this.invalidate();
                return;
            }
        } else if (this.magneticHeading != 0.0) {
            this.invalidate();
            return;
        }
        this.ias = (data[5] & 7) << 7 | data[6] >>> 1;
        if (this.statusIas) {
            if (this.ias <= 0 || this.ias > 512) {
                this.invalidate();
                return;
            }
        } else if (this.ias != 0) {
            this.invalidate();
            return;
        }
        this.mach = (double)(data[7] << 2 | data[8] >> 6) * 4.0;
        this.mach /= 1000.0;
        if (this.statusMach) {
            if (this.mach <= 0.0 || this.mach > 1.0) {
                this.invalidate();
                return;
            }
        } else if (this.mach != 0.0) {
            this.invalidate();
            return;
        }
        double baroSign = (data[8] >>> 4 & 1) == 1 ? -512.0 : 0.0;
        this.baroRocd = ((double)((data[8] & 0xF) << 5 | data[9] >>> 3) + baroSign) * 32.0;
        if (this.statusBaroRocd) {
            if (this.baroRocd < -8000.0 || this.baroRocd > 8000.0) {
                this.invalidate();
                return;
            }
        } else if (this.baroRocd != 0.0) {
            this.invalidate();
            return;
        }
        double irsSign = (data[9] >> 1 & 1) == 1 ? -512.0 : 0.0;
        this.irsRocd = ((double)((data[9] & 1) << 8 | data[10]) + irsSign) * 32.0;
        if (this.statusIrsRocd) {
            if (this.irsRocd < -8000.0 || this.irsRocd > 6000.0) {
                this.invalidate();
                return;
            }
        } else if (this.irsRocd != 0.0) {
            this.invalidate();
            return;
        }
        if (this.statusMach && this.statusIas && data[0] >>> 3 == 20 && (altitude = AltitudeEncoding.decode((data[2] & 0x1F) << 8 | data[3]).getAltitude()) > 0.0 && Math.abs((cas = this.machToCas(altitude * 0.3048) / 0.514444) - (double)this.ias) > 20.0) {
            this.invalidate();
            return;
        }
    }

    private double machToCas(double altitude) {
        return this.tasToCas(this.machToTas(altitude), altitude);
    }

    private double tasToCas(double tas, double altitude) {
        double rho0 = 1.225;
        double T = Math.max(288.15 - 0.0065 * altitude, 216.65);
        double rhotrop = 1.225 * Math.pow(T / 288.15, 4.256848030018761);
        double dhstrat = Math.max(0.0, altitude - 11000.0);
        double rho = rhotrop * Math.exp(-dhstrat / 6341.552161);
        double R = 287.05287;
        double p = rho * R * T;
        double p0 = 101325.0;
        double qdyn = p * (Math.pow(1.0 + rho * tas * tas / (7.0 * p), 3.5) - 1.0);
        return Math.sqrt(7.0 * p0 / rho0 * (Math.pow(qdyn / p0 + 1.0, 0.2857142857142857) - 1.0));
    }

    private double machToTas(double altitude) {
        double T = Math.max(288.15 - 0.0065 * altitude, 216.65);
        double R = 287.05287;
        double gamma = 1.4;
        double a = Math.sqrt(gamma * R * T);
        return this.mach * a;
    }

    @Override
    public void apply(Track track) {
        track.setMagneticHeading(this.magneticHeading);
        track.setIas(this.ias);
        track.setMach(this.mach);
        track.setBaroRocd(this.baroRocd);
        track.setRocd((int)this.irsRocd);
        track.setRocdAvailable(true);
        track.setRocdSourceBaro(!this.statusIrsRocd);
    }

    @Override
    protected void reset() {
        this.statusMagneticHeading = false;
        this.statusIas = false;
        this.statusMach = false;
        this.statusBaroRocd = false;
        this.statusIrsRocd = false;
        this.mach = 0.0;
        this.magneticHeading = 0.0;
        this.ias = 0;
        this.baroRocd = 0.0;
        this.irsRocd = 0.0;
    }

    public boolean isStatusMagneticHeading() {
        return this.statusMagneticHeading;
    }

    public boolean isStatusIas() {
        return this.statusIas;
    }

    public boolean isStatusMach() {
        return this.statusMach;
    }

    public boolean isStatusBaroRocd() {
        return this.statusBaroRocd;
    }

    public boolean isStatusIrsRocd() {
        return this.statusIrsRocd;
    }

    public double getMach() {
        return this.mach;
    }

    public double getMagneticHeading() {
        return this.magneticHeading;
    }

    public int getIas() {
        return this.ias;
    }

    public double getBaroRocd() {
        return this.baroRocd;
    }

    public double getIrsRocd() {
        return this.irsRocd;
    }
}

