/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df.df17;

import aero.t2s.modes.Track;
import aero.t2s.modes.constants.BarometricAltitudeIntegrityCode;
import aero.t2s.modes.constants.SurveillanceStatus;
import aero.t2s.modes.constants.Version;
import aero.t2s.modes.decoder.df.df17.ExtendedSquitter;

public class AirbornePosition
extends ExtendedSquitter {
    private final double originLat;
    private final double originLon;
    private SurveillanceStatus surveillanceStatus;
    private int singleAntennaFlag;
    private boolean altitudeSourceBaro;
    private int altitude;
    private boolean positionAvailable;
    private double lat;
    private double lon;

    public AirbornePosition(short[] data, double originLat, double originLon) {
        super(data);
        this.originLat = originLat;
        this.originLon = originLon;
    }

    @Override
    public AirbornePosition decode() {
        this.surveillanceStatus = SurveillanceStatus.from(this.data[4] >>> 1 & 3);
        this.singleAntennaFlag = this.data[4] & 1;
        this.altitude = this.calculateAltitude(this.data, this.typeCode);
        if (this.typeCode < 20) {
            this.altitudeSourceBaro = true;
        }
        if (this.typeCode == 0) {
            return this;
        }
        this.positionAvailable = true;
        int time = this.data[6] >>> 3 & 1;
        boolean cprEven = (this.data[6] >>> 2 & 1) == 0;
        int cprLat = (this.data[6] & 3) << 15;
        cprLat |= this.data[7] << 7;
        int cprLon = (this.data[8] & 1) << 16;
        cprLon |= this.data[9] << 8;
        this.calculatePosition(cprEven, (double)(cprLat |= this.data[8] >>> 1) / 131072.0, (double)(cprLon |= this.data[10]) / 131072.0, time);
        return this;
    }

    @Override
    public void apply(Track track) {
        track.setGroundBit(false);
        track.setSpi(this.surveillanceStatus == SurveillanceStatus.SPI);
        track.setTempAlert(this.surveillanceStatus == SurveillanceStatus.TEMPORARY_ALERT);
        track.setEmergency(this.surveillanceStatus == SurveillanceStatus.PERMANENT_ALERT);
        if (track.getVersion().ordinal() < Version.VERSION2.ordinal()) {
            track.setSingleAntenna(this.singleAntennaFlag == 0);
        } else {
            track.setNICb(this.singleAntennaFlag);
        }
        if (this.altitudeSourceBaro) {
            track.setBaroAltitude(this.altitude);
        } else {
            track.setGnssHeight(this.altitude);
        }
        track.setNIC(this.determineNIC(track, this.typeCode));
        track.setLat(this.lat);
        track.setLon(this.lon);
    }

    public int getSingleAntennaFlag() {
        return this.singleAntennaFlag;
    }

    public BarometricAltitudeIntegrityCode getNICbaro() {
        try {
            return BarometricAltitudeIntegrityCode.from(this.singleAntennaFlag);
        }
        catch (IllegalArgumentException e) {
            return BarometricAltitudeIntegrityCode.NOT_CROSS_CHECKED;
        }
    }

    public double getOriginLat() {
        return this.originLat;
    }

    public double getOriginLon() {
        return this.originLon;
    }

    public SurveillanceStatus getSurveillanceStatus() {
        return this.surveillanceStatus;
    }

    public boolean isAltitudeSourceBaro() {
        return this.altitudeSourceBaro;
    }

    public int getAltitude() {
        return this.altitude;
    }

    public boolean isPositionAvailable() {
        return this.positionAvailable;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    private int determineNIC(Track track, int typeCode) {
        switch (typeCode) {
            case 9: 
            case 20: {
                return 11;
            }
            case 10: 
            case 21: {
                return 10;
            }
            case 11: {
                if (track.getNICa() == 1 && track.getNICb() == 1) {
                    return 9;
                }
                if (track.getNICa() == 0 && track.getNICb() == 0) {
                    return 8;
                }
                return 0;
            }
            case 12: {
                return 7;
            }
            case 13: {
                return 6;
            }
            case 14: {
                return 5;
            }
            case 15: {
                return 4;
            }
            case 16: {
                if (track.getNICa() == 0 && track.getNICb() == 0) {
                    return 2;
                }
                if (track.getNICa() == 1 && track.getNICb() == 1) {
                    return 3;
                }
                return 0;
            }
            case 17: {
                return 1;
            }
        }
        return 0;
    }

    private void calculatePosition(boolean isEven, double lat, double lon, double time) {
        this.calculateLocal(isEven, lat, lon, time);
    }

    private void calculateLocal(boolean isEven, double lat, double lon, double time) {
        boolean isOdd = !isEven;
        double dlat = isOdd ? 6.101694915254237 : 6.0;
        double j = Math.floor(this.originLat / dlat) + Math.floor(this.originLat % dlat / dlat - lat + 0.5);
        lat = dlat * (j + lat);
        double nl = this.NL(lat) - (isOdd ? 1.0 : 0.0);
        double dlon = nl > 0.0 ? 360.0 / nl : 360.0;
        double m = Math.floor(this.originLon / dlon) + Math.floor(this.originLon % dlon / dlon - lon + 0.5);
        lon = dlon * (m + lon);
        this.lat = lat;
        this.lon = lon;
    }

    private double NL(double lat) {
        if (lat == 0.0) {
            return 59.0;
        }
        if (Math.abs(lat) == 87.0) {
            return 2.0;
        }
        if (Math.abs(lat) > 87.0) {
            return 1.0;
        }
        double tmp = 1.0 - (1.0 - Math.cos(0.10471975511965977)) / Math.pow(Math.cos(Math.PI / 180 * Math.abs(lat)), 2.0);
        return Math.floor(Math.PI * 2 / Math.acos(tmp));
    }

    private int calculateAltitude(short[] data, int typeCode) {
        int n = data[5] >>> 1 << 4;
        int qBit = (data[5] & 1) == 1 ? 25 : 100;
        return (n |= data[6] >>> 4) * qBit - 1000;
    }
}

