/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df.df17;

import aero.t2s.modes.NotImplementedException;
import aero.t2s.modes.Track;
import aero.t2s.modes.constants.NavigationUncertaintyCategory;
import aero.t2s.modes.constants.RocdSource;
import aero.t2s.modes.decoder.df.df17.AirborneVelocityAirspeedHeading;
import aero.t2s.modes.decoder.df.df17.AirborneVelocityGroundspeed;
import aero.t2s.modes.decoder.df.df17.ExtendedSquitter;

public class AirborneVelocity
extends ExtendedSquitter {
    protected NavigationUncertaintyCategory NACv;
    private int subType;
    private boolean supersonic;
    private boolean intentChange;
    private boolean ifrCapability;
    private boolean rocdAvailable;
    private RocdSource rocdSource;
    private int rocd;
    private boolean gnssAltitudeDifferenceFromBaroAvailable;
    private int gnssAltitudeDifferenceFromBaro;

    public AirborneVelocity(short[] data) {
        super(data);
    }

    @Override
    public AirborneVelocity decode() {
        int subType = this.data[4] & 7;
        switch (subType) {
            case 1: 
            case 2: {
                return new AirborneVelocityGroundspeed(this.data).decode();
            }
            case 3: 
            case 4: {
                return new AirborneVelocityAirspeedHeading(this.data).decode();
            }
        }
        throw new NotImplementedException("BDS0,9 sub type " + subType + " is not implemented");
    }

    @Override
    public void apply(Track track) {
    }

    protected void decodeCommonInformation() {
        this.subType = this.data[4] & 7;
        this.supersonic = this.subType == 2;
        this.intentChange = (this.data[5] & 0x80) != 0;
        this.ifrCapability = (this.data[5] & 0x40) != 0;
        this.NACv = NavigationUncertaintyCategory.from((this.data[5] & 0x38) >>> 3);
        this.rocdSource = (this.data[8] & 0x10) != 0 ? RocdSource.BARO : RocdSource.GNSS;
        this.rocd = (this.data[8] & 7) << 6 | (this.data[9] & 0xFC) >>> 2;
        this.rocdAvailable = this.rocd != 0;
        this.rocd = (this.rocd - 1) * 64;
        if ((this.data[8] & 8) != 0) {
            this.rocd *= -1;
        }
        this.gnssAltitudeDifferenceFromBaro = this.data[10] & 0x7F;
        this.gnssAltitudeDifferenceFromBaroAvailable = this.gnssAltitudeDifferenceFromBaro != 0;
        this.gnssAltitudeDifferenceFromBaro = (this.gnssAltitudeDifferenceFromBaro - 1) * 25;
        if ((this.data[10] & 0x80) != 0) {
            this.gnssAltitudeDifferenceFromBaro *= -1;
        }
    }

    public NavigationUncertaintyCategory getNACv() {
        return this.NACv;
    }

    public int getSubType() {
        return this.subType;
    }

    public boolean isSupersonic() {
        return this.supersonic;
    }

    public boolean isIntentChange() {
        return this.intentChange;
    }

    public boolean isIfrCapability() {
        return this.ifrCapability;
    }

    public boolean isRocdAvailable() {
        return this.rocdAvailable;
    }

    public RocdSource getRocdSource() {
        return this.rocdSource;
    }

    public int getRocd() {
        return this.rocd;
    }

    public boolean isGnssAltitudeDifferenceFromBaroAvailable() {
        return this.gnssAltitudeDifferenceFromBaroAvailable;
    }

    public int getGnssAltitudeDifferenceFromBaro() {
        return this.gnssAltitudeDifferenceFromBaro;
    }
}

