/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df.df17;

import aero.t2s.modes.Track;
import aero.t2s.modes.constants.RocdSource;
import aero.t2s.modes.constants.Speed;
import aero.t2s.modes.decoder.df.df17.AirborneVelocity;

public class AirborneVelocityAirspeedHeading
extends AirborneVelocity {
    private static final double HEADING_RESOLUTION = 0.3515625;
    private boolean headingAvailable;
    private double heading;
    private boolean airspeedAvailable;
    private Speed airspeedType;
    private int airspeed;

    public AirborneVelocityAirspeedHeading(short[] data) {
        super(data);
    }

    @Override
    public AirborneVelocityAirspeedHeading decode() {
        this.decodeCommonInformation();
        this.headingAvailable = (this.data[5] & 4) != 0;
        this.heading = (double)((this.data[5] & 3) << 8 | this.data[6]) * 0.3515625;
        this.airspeed = (this.data[7] & 0x7F) << 3 | (this.data[8] & 0xE0) >>> 5;
        this.airspeedAvailable = this.airspeed != 0;
        this.airspeed = (this.airspeed - 1) * (this.isSupersonic() ? 4 : 1);
        this.airspeedType = (this.data[7] & 0x80) != 0 ? Speed.TAS : Speed.IAS;
        return this;
    }

    @Override
    public void apply(Track track) {
        track.setNACv(this.NACv.ordinal());
        if (this.isGnssAltitudeDifferenceFromBaroAvailable()) {
            track.setGeometricHeightOffset(this.getGnssAltitudeDifferenceFromBaro());
        }
        if (this.isRocdAvailable()) {
            track.setRocdAvailable(true);
            track.setRocdSourceBaro(this.getRocdSource() == RocdSource.BARO);
            if (this.getRocdSource() == RocdSource.BARO) {
                track.setBaroRocd(this.getRocd());
            } else {
                track.setRocd(this.getRocd());
            }
        }
    }

    public boolean isHeadingAvailable() {
        return this.headingAvailable;
    }

    public double getHeading() {
        return this.heading;
    }

    public boolean isAirspeedAvailable() {
        return this.airspeedAvailable;
    }

    public Speed getAirspeedType() {
        return this.airspeedType;
    }

    public int getAirspeed() {
        return this.airspeed;
    }
}

