/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df.df17;

import aero.t2s.modes.Track;
import aero.t2s.modes.constants.Angle;
import aero.t2s.modes.constants.BarometricAltitudeIntegrityCode;
import aero.t2s.modes.constants.GeometricVerticalAccuracy;
import aero.t2s.modes.constants.NavigationIntegrityCategory;
import aero.t2s.modes.constants.SourceIntegrityLevel;
import aero.t2s.modes.constants.SourceIntegrityLevelSupplement;
import aero.t2s.modes.constants.Version;
import aero.t2s.modes.decoder.df.df17.AircraftOperationalStatusVersion2;
import aero.t2s.modes.decoder.df.df17.data.AirborneCapability;
import aero.t2s.modes.decoder.df.df17.data.AirborneOperationalMode;

public class AircraftOperationalStatusVersion2Airborne
extends AircraftOperationalStatusVersion2 {
    private AirborneCapability capability;
    private AirborneOperationalMode operationalMode;
    private SourceIntegrityLevelSupplement SILsupp;
    private BarometricAltitudeIntegrityCode NICbaro;
    private NavigationIntegrityCategory NICp;
    private SourceIntegrityLevel SIL;
    private Angle horizontalSource;
    private GeometricVerticalAccuracy gva;
    private Version version;

    public AircraftOperationalStatusVersion2Airborne(short[] data) {
        super(data);
    }

    @Override
    public AircraftOperationalStatusVersion2Airborne decode() {
        this.version = Version.VERSION2;
        this.capability = new AirborneCapability(this.data[5] << 8 | this.data[6], this.version);
        this.operationalMode = new AirborneOperationalMode(this.data[7] << 8 | this.data[8]);
        int NICsuppA = (this.data[9] & 0x10) >>> 4;
        int NACp = this.data[9] & 0xF;
        this.NICp = NavigationIntegrityCategory.airborne(NACp, NICsuppA, 0);
        this.gva = GeometricVerticalAccuracy.from((this.data[10] & 0xC0) >>> 6);
        this.SIL = SourceIntegrityLevel.from((this.data[10] & 0x30) >>> 4);
        this.NICbaro = BarometricAltitudeIntegrityCode.from((this.data[10] & 8) >>> 3);
        this.horizontalSource = (this.data[10] & 4) != 0 ? Angle.TRUE_HEADING : Angle.MAGNETIC_HEADING;
        this.SILsupp = SourceIntegrityLevelSupplement.from((this.data[10] & 2) >>> 1);
        return this;
    }

    @Override
    public void apply(Track track) {
        track.setVersion(this.version);
    }

    public AirborneCapability getCapability() {
        return this.capability;
    }

    public AirborneOperationalMode getOperationalMode() {
        return this.operationalMode;
    }

    public SourceIntegrityLevelSupplement getSILsupp() {
        return this.SILsupp;
    }

    public BarometricAltitudeIntegrityCode getNICbaro() {
        return this.NICbaro;
    }

    public NavigationIntegrityCategory getNICp() {
        return this.NICp;
    }

    public SourceIntegrityLevel getSIL() {
        return this.SIL;
    }

    public Angle getHorizontalSource() {
        return this.horizontalSource;
    }

    public GeometricVerticalAccuracy getGva() {
        return this.gva;
    }

    public Version getVersion() {
        return this.version;
    }
}

