/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes;

import aero.t2s.modes.BinaryHelper;
import aero.t2s.modes.EmptyMessageException;
import aero.t2s.modes.ModeAcMessageException;
import aero.t2s.modes.Track;
import aero.t2s.modes.decoder.df.DownlinkFormat;
import java.util.function.Consumer;

public abstract class ModeSHandler {
    protected Consumer<Track> onDeleted = track -> {};
    protected Consumer<Track> onCreated = track -> {};
    protected Consumer<Track> onUpdated = track -> {};
    protected Consumer<DownlinkFormat> onMessage;

    public void onTrackDeleted(Consumer<Track> onDeleted) {
        this.onDeleted = onDeleted;
    }

    public void onTrackUpdated(Consumer<Track> onUpdated) {
        this.onUpdated = onUpdated;
    }

    public void onTrackCreated(Consumer<Track> onCreated) {
        this.onCreated = onCreated;
    }

    public void onMessage(Consumer<DownlinkFormat> onMessage) {
        this.onMessage = onMessage;
    }

    public abstract void handle(String var1);

    public abstract DownlinkFormat handleSync(String var1);

    protected short[] toData(String input) throws EmptyMessageException, ModeAcMessageException {
        if (input.length() == 6) {
            throw new ModeAcMessageException();
        }
        if (input.startsWith("*0000")) {
            throw new EmptyMessageException();
        }
        String hex = input.replace("*", "").replace(";", "");
        return BinaryHelper.stringToByteArray(hex);
    }

    public void start() {
    }

    public void stop() {
    }
}

