/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes;

import aero.t2s.modes.ModeSHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import org.slf4j.LoggerFactory;

class ModeSListener
extends Thread {
    private final InetSocketAddress address;
    private final ModeSHandler handler;
    private int attempts;
    private boolean running = true;

    public ModeSListener(InetSocketAddress address, ModeSHandler handler) {
        super("Mode S Listener");
        this.address = address;
        this.handler = handler;
    }

    @Override
    public void run() {
        while (!this.isInterrupted() && this.running) {
            try {
                SocketChannel socketChannel = SocketChannel.open();
                try {
                    ++this.attempts;
                    LoggerFactory.getLogger(this.getClass()).info("[ModeSListener] Connecting to {}", (Object)this.address.toString());
                    socketChannel.connect(this.address);
                    BufferedReader is = new BufferedReader(new InputStreamReader(socketChannel.socket().getInputStream()));
                    this.attempts = 0;
                    while (!this.isInterrupted()) {
                        String hex = is.readLine();
                        this.handler.handle(hex);
                    }
                }
                finally {
                    if (socketChannel == null) continue;
                    socketChannel.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (this.attempts != 5 && !this.isInterrupted()) continue;
                LoggerFactory.getLogger(this.getClass()).info("[ModeSListener] Disconnecting");
                this.running = false;
            }
        }
    }
}

