/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes;

import aero.t2s.modes.EmptyMessageException;
import aero.t2s.modes.ModeAcMessageException;
import aero.t2s.modes.ModeSHandler;
import aero.t2s.modes.Track;
import aero.t2s.modes.database.ModeSDatabase;
import aero.t2s.modes.decoder.Decoder;
import aero.t2s.modes.decoder.UnknownDownlinkFormatException;
import aero.t2s.modes.decoder.df.DownlinkFormat;
import aero.t2s.modes.decoder.df.df17.InvalidExtendedSquitterTypeCodeException;
import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModeSMessageHandler
extends ModeSHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModeSMessageHandler.class);
    private final Decoder decoder;
    private final Executor executor = Executors.newSingleThreadExecutor();
    private Consumer<DownlinkFormat> onMessage;

    public ModeSMessageHandler(double originLat, double originLon) {
        this.decoder = new Decoder(new HashMap<String, Track>(), originLat, originLon, ModeSDatabase.createDatabase());
    }

    @Override
    public void handle(String input) {
        this.executor.execute(() -> this.handleSync(input));
    }

    @Override
    public DownlinkFormat handleSync(String input) {
        try {
            DownlinkFormat df = this.decoder.decode(this.toData(input));
            if (this.onMessage != null) {
                this.onMessage.accept(df);
            }
            return df;
        }
        catch (EmptyMessageException | ModeAcMessageException df) {
        }
        catch (UnknownDownlinkFormatException | InvalidExtendedSquitterTypeCodeException e) {
            LOGGER.error(e.getMessage());
        }
        catch (Throwable throwable) {
            LOGGER.error("Message could not be parsed", throwable);
        }
        return null;
    }

    @Override
    public void onMessage(Consumer<DownlinkFormat> onMessage) {
        this.onMessage = onMessage;
    }
}

