/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder;

import java.util.Arrays;

public class Common {
    private static final String chars = "#ABCDEFGHIJKLMNOPQRSTUVWXYZ#####_###############0123456789######";
    private static final char[] haxChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final short[] CRC_POLYNOMIAL = new short[]{255, 244, 9};

    public static String icao(String hex) {
        if (hex.length() < 9) {
            return null;
        }
        return hex.substring(3, 9);
    }

    public static String charToString(int character) {
        if (character > chars.length()) {
            return "#";
        }
        return chars.substring(character, character + 1);
    }

    public static String toHexString(short[] data) {
        int length = data.length;
        char[] out = new char[length << 1];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            out[j++] = haxChars[(0xF0 & data[i]) >>> 4];
            out[j++] = haxChars[0xF & data[i]];
        }
        return new String(out);
    }

    public static short xor(short short1, short short2) {
        return (short)(0xFF & (short1 ^ short2));
    }

    public static short[] xor(short[] array1, short[] array2) {
        assert (array1.length == array2.length);
        short[] res = new short[array1.length];
        for (int i = 0; i < array1.length; ++i) {
            res[i] = Common.xor(array1[i], array2[i]);
        }
        return res;
    }

    public static String getIcaoAddressFromParity(short[] data) {
        short[] payload = Arrays.copyOfRange(data, 0, data.length - 3);
        short[] parity = Arrays.copyOfRange(data, data.length - 3, data.length);
        return Common.getIcaoAddress(payload, parity);
    }

    public static String getIcaoAddress(short[] data, short[] messageParity) {
        short[] calculatedParity = Common.getParity(data);
        return Common.toHexString(Common.xor(calculatedParity, messageParity));
    }

    public static short[] getParity(short[] data) {
        short[] parity = Arrays.copyOf(data, CRC_POLYNOMIAL.length);
        for (int i = 0; i < data.length * 8; ++i) {
            boolean invert = (parity[0] & 0x80) != 0;
            parity[0] = (short)(parity[0] << 1);
            int b = 1;
            while (b < CRC_POLYNOMIAL.length) {
                int n = b - 1;
                parity[n] = (short)(parity[n] | parity[b] >>> 7 & 1);
                int n2 = b++;
                parity[n2] = (short)(parity[n2] << 1);
            }
            int index = (CRC_POLYNOMIAL.length * 8 + i) / 8;
            int shift = 7 - i % 8;
            if (index < data.length) {
                int n = parity.length - 1;
                parity[n] = (short)(parity[n] | data[index] >>> shift & 1);
            }
            if (!invert) continue;
            for (b = 0; b < CRC_POLYNOMIAL.length; ++b) {
                int n = b;
                parity[n] = (short)(parity[n] ^ CRC_POLYNOMIAL[b]);
            }
        }
        return Arrays.copyOf(parity, CRC_POLYNOMIAL.length);
    }

    public static boolean isNotValid(short[] data) {
        if (data.length < 3) {
            return true;
        }
        short[] payload = Arrays.copyOfRange(data, 0, data.length - 3);
        short[] parity = Arrays.copyOfRange(data, data.length - 3, data.length);
        return Common.areEqual(Common.getParity(payload), parity);
    }

    public static boolean areEqual(short[] array1, short[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isFlightStatusAlert(int fs) {
        return fs >= 2 && fs <= 4;
    }

    public static boolean isFlightStatusSpi(int fs) {
        return fs == 4 || fs == 5;
    }

    public static int modeA(int encoded) {
        int c1 = encoded >>> 12 & 1;
        int a1 = encoded >>> 11 & 1;
        int c2 = encoded >>> 10 & 1;
        int a2 = encoded >>> 9 & 1;
        int c4 = encoded >>> 8 & 1;
        int a4 = encoded >>> 7 & 1;
        int x = encoded >>> 6 & 1;
        int b1 = encoded >>> 5 & 1;
        int d1 = encoded >>> 4 & 1;
        int b2 = encoded >>> 3 & 1;
        int d2 = encoded >>> 2 & 1;
        int b4 = encoded >>> 1 & 1;
        int d4 = encoded & 1;
        int n1 = (a4 << 2 | a2 << 1 | a1) * 1000;
        int n2 = (b4 << 2 | b2 << 1 | b1) * 100;
        int n3 = (c4 << 2 | c2 << 1 | c1) * 10;
        int n4 = d4 << 2 | d2 << 1 | d1;
        return n1 + n2 + n3 + n4;
    }

    public static double tidr(int encodedDistance) {
        if (encodedDistance == 0) {
            return -1.0;
        }
        return ((double)encodedDistance - 1.0) / 10.0;
    }

    public static int tidb(int encodedBearing) {
        if (encodedBearing == 0) {
            return -1;
        }
        return 6 * (encodedBearing - 1);
    }
}

