/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df;

import aero.t2s.modes.Track;
import aero.t2s.modes.decoder.Common;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DownlinkFormat {
    protected static final Logger logger = LoggerFactory.getLogger(DownlinkFormat.class);
    protected final short[] data;
    private final String icao;

    public DownlinkFormat(short[] data, IcaoAddress icaoAddressFrom) {
        this.data = data;
        this.icao = icaoAddressFrom == IcaoAddress.FROM_PARITY ? Common.getIcaoAddressFromParity(data) : Common.toHexString(Arrays.copyOfRange(data, 1, 4));
    }

    public abstract DownlinkFormat decode();

    public abstract void apply(Track var1);

    public String getIcao() {
        return this.icao;
    }

    public short[] getData() {
        return this.data;
    }

    protected static enum IcaoAddress {
        FROM_MESSAGE,
        FROM_PARITY;

    }
}

