/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df.bds;

import aero.t2s.modes.Meteo;
import aero.t2s.modes.Track;
import aero.t2s.modes.constants.Hazard;
import aero.t2s.modes.constants.MeteoSource;
import aero.t2s.modes.decoder.df.bds.Bds;

public class Bds44
extends Bds {
    private static final double WIND_DIRECTION_ACCURACY = 0.703125;
    private static final double SAT_ACCURACY = 0.25;
    private static final double HUMIDITY_ACCURACY = 1.5625;
    private MeteoSource source;
    private int windSpeed;
    private boolean statusWindSpeed;
    private double windDirection;
    private double humidity;
    private boolean statusHumidity;
    private boolean statusTurbulence;
    private Hazard turbulence;
    private int averageStaticPressure;
    private boolean statusAverageStaticPressure;
    private double staticAirTemperature;

    public Bds44(short[] data) {
        super(data);
        this.source = MeteoSource.find(data[4] >>> 4);
        if (this.source == MeteoSource.INVALID || this.source == MeteoSource.RESERVED) {
            this.invalidate();
            return;
        }
        this.statusWindSpeed = (data[4] & 8) != 0;
        this.windSpeed = (data[4] & 7) << 6 | data[5] >> 2;
        this.windDirection = (double)((data[5] & 3) << 7 | data[6] >> 1) * 0.703125;
        if (!this.statusWindSpeed && this.windSpeed != 0) {
            this.invalidate();
            return;
        }
        if (this.statusWindSpeed && this.windSpeed > 250) {
            this.invalidate();
            return;
        }
        boolean isSatNegative = (data[6] & 1) == 1;
        this.staticAirTemperature = (double)(data[7] << 2 | data[8] >>> 6) * 0.25 * (double)(isSatNegative ? -1 : 1);
        if (this.staticAirTemperature > 60.0 || this.staticAirTemperature < -80.0) {
            this.invalidate();
            return;
        }
        this.statusAverageStaticPressure = (data[8] & 0x20) != 0;
        this.averageStaticPressure = (data[8] & 0x1F) << 6 | data[9] >> 2;
        if (!this.statusAverageStaticPressure && this.averageStaticPressure != 0) {
            this.invalidate();
            return;
        }
        this.statusTurbulence = (data[9] & 2) != 0;
        this.turbulence = Hazard.find((data[9] & 1) << 1 | data[10] >>> 7);
        if (!this.statusTurbulence && this.turbulence != Hazard.NIL) {
            this.invalidate();
            return;
        }
        this.statusHumidity = (data[10] & 0x40) != 0;
        this.humidity = (double)(data[10] & 0x3F) * 1.5625;
        if (!this.statusHumidity && this.humidity != 0.0) {
            this.invalidate();
            return;
        }
    }

    @Override
    public void apply(Track track) {
        Meteo meteo = track.getMeteo();
        if (this.statusWindSpeed) {
            meteo.setWindSpeed(this.windSpeed);
            meteo.setWindDirection(this.windDirection);
        }
        if (this.statusAverageStaticPressure) {
            meteo.setAverageStaticPressure(this.averageStaticPressure);
        }
        if (this.statusTurbulence) {
            meteo.setTurbulence(this.turbulence);
        }
        meteo.setStaticAirTemperature(this.staticAirTemperature);
        if (this.statusHumidity) {
            meteo.setHumidity(this.humidity);
        }
    }

    @Override
    protected void reset() {
        this.statusAverageStaticPressure = false;
        this.statusWindSpeed = false;
        this.statusHumidity = false;
        this.statusTurbulence = false;
        this.source = null;
        this.windSpeed = 0;
        this.windDirection = 0.0;
        this.humidity = 0.0;
        this.turbulence = null;
        this.averageStaticPressure = 0;
        this.staticAirTemperature = 0.0;
    }

    public MeteoSource getSource() {
        return this.source;
    }

    public int getWindSpeed() {
        return this.windSpeed;
    }

    public boolean isStatusWindSpeed() {
        return this.statusWindSpeed;
    }

    public double getWindDirection() {
        return this.windDirection;
    }

    public double getHumidity() {
        return this.humidity;
    }

    public boolean isStatusHumidity() {
        return this.statusHumidity;
    }

    public boolean isStatusTurbulence() {
        return this.statusTurbulence;
    }

    public Hazard getTurbulence() {
        return this.turbulence;
    }

    public int getAverageStaticPressure() {
        return this.averageStaticPressure;
    }

    public boolean isStatusAverageStaticPressure() {
        return this.statusAverageStaticPressure;
    }

    public double getStaticAirTemperature() {
        return this.staticAirTemperature;
    }
}

