/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df.bds;

import aero.t2s.modes.Track;
import aero.t2s.modes.decoder.df.bds.Bds;

public class Bds53
extends Bds {
    private static final double HEADING_ACCURACY = 0.17578125;
    private static final double MACH_ACCURACY = 0.008;
    private static final double TAS_ACCURACY = 0.5;
    private static final int VS_ACCURACY = 64;
    private boolean statusRocd;
    private boolean statusTas;
    private boolean statusMach;
    private boolean statusIas;
    private boolean statusMagneticHeading;
    private double magneticHeading;
    private int rocd;
    private double tas;
    private double mach;
    private int ias;

    public Bds53(short[] data) {
        super(data);
        this.statusMagneticHeading = (data[4] & 0x80) == 128;
        this.statusIas = (data[5] & 8) == 8;
        this.statusMach = (data[6] & 1) == 1;
        this.statusTas = (data[8] & 0x40) == 64;
        this.statusRocd = (data[9] & 2) == 2;
        boolean isMagHdgNegative = (data[4] & 0x40) == 64;
        this.magneticHeading = (double)((data[4] & 0x3F) << 4 | data[5] & 0xF0) * 0.17578125 + (double)(isMagHdgNegative ? 180 : 0);
        if (!this.statusMagneticHeading && this.magneticHeading != 0.0 || this.magneticHeading > 360.0) {
            this.invalidate();
            return;
        }
        this.ias = (data[5] & 7) << 7 | (data[6] & 0xFE) >>> 1;
        if (!this.statusIas && this.ias != 0) {
            this.invalidate();
            return;
        }
        if (this.statusIas && this.ias > 500) {
            this.invalidate();
            return;
        }
        this.mach = (double)(data[7] << 1 | data[8] >>> 7) * 0.008;
        if (!this.statusMach && this.mach != 0.0) {
            this.invalidate();
            return;
        }
        this.tas = (double)((data[8] & 0x3F) << 6 | (data[9] & 0xFC) >>> 2) * 0.5;
        if (!this.statusTas && this.tas != 0.0) {
            this.invalidate();
            return;
        }
        if (this.statusTas && this.tas > 500.0) {
            this.invalidate();
            return;
        }
        boolean isRocdNegative = (data[9] & 1) == 1;
        this.rocd = data[10] * 64 * (isRocdNegative ? -1 : 1);
        if (!this.statusRocd && this.rocd != 0) {
            this.invalidate();
            return;
        }
    }

    @Override
    public void apply(Track track) {
        if (this.statusMagneticHeading) {
            track.setMagneticHeading(this.magneticHeading);
        }
        if (this.statusIas) {
            track.setIas(this.ias);
        }
        if (this.statusMach) {
            track.setMach(this.mach);
        }
        if (this.statusTas) {
            track.setTas(this.tas);
        }
        if (this.statusRocd) {
            track.setRocd(this.rocd);
        }
    }

    @Override
    protected void reset() {
        this.statusRocd = false;
        this.statusTas = false;
        this.statusMach = false;
        this.statusIas = false;
        this.statusMagneticHeading = false;
        this.magneticHeading = 0.0;
        this.rocd = 0;
        this.tas = 0.0;
        this.mach = 0.0;
        this.ias = 0;
    }

    public double getMagneticHeading() {
        return this.magneticHeading;
    }

    public boolean isStatusRocd() {
        return this.statusRocd;
    }

    public boolean isStatusTas() {
        return this.statusTas;
    }

    public boolean isStatusMach() {
        return this.statusMach;
    }

    public boolean isStatusIas() {
        return this.statusIas;
    }

    public boolean isStatusMagneticHeading() {
        return this.statusMagneticHeading;
    }

    public int getRocd() {
        return this.rocd;
    }

    public double getTas() {
        return this.tas;
    }

    public double getMach() {
        return this.mach;
    }

    public int getIas() {
        return this.ias;
    }
}

