/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df.df17;

import aero.t2s.modes.Track;
import aero.t2s.modes.constants.BarometricAltitudeIntegrityCode;
import aero.t2s.modes.constants.NavigationAccuracyCategoryPosition;
import aero.t2s.modes.constants.SelectedAltitudeSource;
import aero.t2s.modes.constants.SourceIntegrityLevel;
import aero.t2s.modes.constants.SourceIntegrityLevelSupplement;
import aero.t2s.modes.decoder.df.df17.TargetStatusMessage;

public class TargetStatusMessageType1
extends TargetStatusMessage {
    private static final double HEADING_RESOLUTION = 0.703125;
    private int subType = 1;
    private SelectedAltitudeSource selectedAltitudeType;
    private int selectedAltitude;
    private double baroSetting;
    private boolean selectedHeadingAvailable;
    private double selectedHeading;
    private SourceIntegrityLevelSupplement SILsupp;
    private SourceIntegrityLevel SIL;
    private NavigationAccuracyCategoryPosition NACp;
    private BarometricAltitudeIntegrityCode NICbaro;
    private boolean autopilot;
    private boolean autopilotLnav;
    private boolean autopilotVnav;
    private boolean autopilotAltitudeHold;
    private boolean autopilotApproach;
    private boolean acasOperation;

    public TargetStatusMessageType1(short[] data) {
        super(data);
    }

    @Override
    public TargetStatusMessageType1 decode() {
        this.SILsupp = SourceIntegrityLevelSupplement.from(this.data[4] & 1);
        this.selectedAltitudeType = (this.data[9] & 2) == 0 ? SelectedAltitudeSource.UNKNOWN : (this.data[5] >>> 7 == 1 ? SelectedAltitudeSource.FMS : SelectedAltitudeSource.MCP);
        if (this.selectedAltitudeType != SelectedAltitudeSource.UNKNOWN) {
            this.selectedAltitude = ((this.data[5] & 0x7F) << 4 | (this.data[6] >>> 4) - 2) * 32;
        }
        this.baroSetting = (this.data[6] & 0xF) << 5 | this.data[7] >>> 3;
        if (this.baroSetting != 0.0) {
            this.baroSetting = (this.baroSetting - 1.0) * 0.8 + 800.0;
        }
        boolean bl = this.selectedHeadingAvailable = (this.data[7] >>> 2 & 1) == 1;
        if (this.selectedHeadingAvailable) {
            boolean isNegativeHeading = (this.data[7] >>> 1 & 1) == 1;
            this.selectedHeading = (double)((this.data[7] & 1) << 7 | this.data[8] >>> 1) * 0.703125;
            if (isNegativeHeading) {
                this.selectedHeading += 180.0;
            }
        }
        this.NACp = NavigationAccuracyCategoryPosition.find((this.data[8] & 1) << 3 | this.data[9] >>> 5);
        this.NICbaro = BarometricAltitudeIntegrityCode.from(this.data[9] >>> 4 & 1);
        this.SIL = SourceIntegrityLevel.from(this.data[9] >>> 2 & 3);
        this.autopilot = (this.data[9] & 1) == 1;
        this.autopilotVnav = this.data[10] >>> 7 == 1;
        this.autopilotAltitudeHold = (this.data[10] >>> 6 & 1) == 1;
        this.autopilotApproach = (this.data[10] >>> 4 & 1) == 1;
        this.acasOperation = (this.data[10] >>> 3 & 1) == 1;
        this.autopilotLnav = (this.data[10] >>> 2 & 1) == 1;
        return this;
    }

    @Override
    public void apply(Track track) {
        track.setSelectedAltitudeManagedFms(this.selectedAltitudeType == SelectedAltitudeSource.FMS);
        track.setSelectedAltitudeManagedMcp(this.selectedAltitudeType == SelectedAltitudeSource.MCP);
        track.setSelectedAltitude(this.selectedAltitudeType != SelectedAltitudeSource.UNKNOWN ? this.selectedAltitude : 0);
        if (this.isBaroAvailable()) {
            track.setBaroAltitude((int)Math.round(this.baroSetting));
        }
        if (this.selectedHeadingAvailable) {
            track.setSelectedHeading(this.selectedHeading);
        }
        track.setNACp(this.NACp);
        track.setNICb(this.NICbaro.ordinal());
        track.setSil(this.SIL.ordinal());
        track.setAutopilot(this.autopilot);
        track.setVnav(this.autopilotVnav);
        track.setAltitudeHold(this.autopilotAltitudeHold);
        track.setApproachMode(this.autopilotApproach);
        track.getAcas().setActive(this.acasOperation);
        track.setLnav(this.autopilotLnav);
    }

    public int getSubType() {
        return this.subType;
    }

    public SourceIntegrityLevelSupplement getSILsupp() {
        return this.SILsupp;
    }

    public SelectedAltitudeSource getSelectedAltitudeType() {
        return this.selectedAltitudeType;
    }

    public int getSelectedAltitude() {
        return this.selectedAltitude;
    }

    public double getBaroSetting() {
        return this.baroSetting;
    }

    public boolean isBaroAvailable() {
        return this.baroSetting != 0.0;
    }

    public boolean isSelectedHeadingAvailable() {
        return this.selectedHeadingAvailable;
    }

    public double getSelectedHeading() {
        return this.selectedHeading;
    }

    public SourceIntegrityLevel getSIL() {
        return this.SIL;
    }

    public NavigationAccuracyCategoryPosition getNACp() {
        return this.NACp;
    }

    public BarometricAltitudeIntegrityCode getNICbaro() {
        return this.NICbaro;
    }

    public boolean isAutopilot() {
        return this.autopilot;
    }

    public boolean isAutopilotLnav() {
        return this.autopilotLnav;
    }

    public boolean isAutopilotVnav() {
        return this.autopilotVnav;
    }

    public boolean isAutopilotAltitudeHold() {
        return this.autopilotAltitudeHold;
    }

    public boolean isAutopilotApproach() {
        return this.autopilotApproach;
    }

    public boolean isAcasOperation() {
        return this.acasOperation;
    }
}

