/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df.df17.data;

import aero.t2s.modes.constants.TargetChangeReportCapability;
import aero.t2s.modes.constants.Version;

public class AirborneCapability {
    private boolean acasOperational;
    private boolean receive1090ES;
    private boolean cockpitDisplayOfTraffic;
    private boolean sendAirReferencedVelocityReport;
    private boolean sendTargetSateReport;
    private TargetChangeReportCapability targetChangeReportCapability;
    private boolean uatReceive;
    private Version version;

    public AirborneCapability(int data, Version version) {
        this.version = version;
        this.acasOperational = (data & 0x2000) != 0;
        this.receive1090ES = (data & 0x1000) != 0;
        this.cockpitDisplayOfTraffic = (data & 0x1000) != 0;
        this.sendAirReferencedVelocityReport = (data & 0x200) != 0;
        this.sendTargetSateReport = (data & 0x100) != 0;
        this.targetChangeReportCapability = TargetChangeReportCapability.from((data & 0xC0) >>> 6);
        this.uatReceive = (data & 0x20) != 0;
    }

    public boolean isAcasOperational() {
        return this.acasOperational;
    }

    public boolean isReceive1090ES() {
        return this.receive1090ES;
    }

    public boolean isSendAirReferencedVelocityReport() {
        return this.sendAirReferencedVelocityReport;
    }

    public boolean isSendTargetSateReport() {
        return this.sendTargetSateReport;
    }

    public TargetChangeReportCapability getTargetChangeReportCapability() {
        return this.targetChangeReportCapability;
    }

    public boolean isUatReceive() {
        return this.uatReceive;
    }

    public boolean isCockpitDisplayOfTraffic() {
        return this.cockpitDisplayOfTraffic;
    }

    public Version getVersion() {
        return this.version;
    }
}

