/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df.df17.data;

import aero.t2s.modes.constants.NavigationUncertaintyCategory;
import aero.t2s.modes.constants.Version;

public class SurfaceCapability {
    private boolean receive1090ES;
    private boolean lowB2Power;
    private boolean uatReceive;
    private boolean cockpitDisplayOfTraffic;
    private boolean positionOffsetApplied;
    private NavigationUncertaintyCategory NACv;
    private short NICsuppC;
    private Version version;

    public SurfaceCapability(int data, Version version) {
        this.version = version;
        boolean bl = this.lowB2Power = (data & 0x20) != 0;
        if (version == Version.VERSION1) {
            this.positionOffsetApplied = (data & 0x200) != 0;
            this.cockpitDisplayOfTraffic = (data & 0x100) != 0;
        } else {
            this.receive1090ES = (data & 0x100) != 0;
            this.uatReceive = (data & 0x10) != 0;
            this.NACv = NavigationUncertaintyCategory.from((data & 0xE) >>> 1);
            this.NICsuppC = (short)(data & 1);
        }
    }

    public boolean isReceive1090ES() {
        return this.receive1090ES;
    }

    public boolean isLowB2Power() {
        return this.lowB2Power;
    }

    public boolean isUatReceive() {
        return this.uatReceive;
    }

    public NavigationUncertaintyCategory getNACv() {
        return this.NACv;
    }

    public short getNICsuppC() {
        return this.NICsuppC;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean isCockpitDisplayOfTraffic() {
        return this.cockpitDisplayOfTraffic;
    }

    public boolean isPositionOffsetApplied() {
        return this.positionOffsetApplied;
    }
}

