/*
 * Decompiled with CFR 0.152.
 */
package aero.t2s.modes.decoder.df.df17.data;

import aero.t2s.modes.constants.AcasState;
import aero.t2s.modes.constants.SourceIntegrityLevel;

public class SurfaceOperationalMode {
    private AcasState acasRA;
    private boolean acasIdent;
    private boolean singleAntennaFlag;
    private SourceIntegrityLevel systemDesignAssurance;
    private boolean gpsLateralOffsetAvailable;
    private int gpsLateralOffset;
    private boolean gpsLongitudinalOffsetAvailable;
    private boolean gpsLongitudinalOffsetAppliedBySensor;
    private int gpsLongitudinalOffset;

    public SurfaceOperationalMode(int data) {
        this.acasRA = (data & 0x2000) != 0 ? AcasState.RA_ACTIVE : AcasState.RA_NOT_ACTIVE;
        this.acasIdent = (data & 0x1000) != 0;
        this.singleAntennaFlag = (data & 0x400) != 0;
        this.systemDesignAssurance = SourceIntegrityLevel.from((data & 0x300) >>> 7);
        int gpsAntennaOffset = data & 0xFF;
        this.gpsLateralOffset = (gpsAntennaOffset & 0xE0) >>> 5;
        if ((this.gpsLateralOffset & 4) == 0) {
            this.gpsLateralOffset = (this.gpsLateralOffset & 3) * 2;
            this.gpsLateralOffsetAvailable = this.gpsLateralOffset != 0;
        } else {
            this.gpsLateralOffset = (this.gpsLateralOffset & 3) * -2;
            this.gpsLateralOffsetAvailable = true;
        }
        this.gpsLongitudinalOffset = gpsAntennaOffset & 0x1F;
        this.gpsLongitudinalOffsetAvailable = this.gpsLongitudinalOffset != 0;
        this.gpsLongitudinalOffsetAppliedBySensor = this.gpsLongitudinalOffset == 1;
        this.gpsLongitudinalOffset = (this.gpsLongitudinalOffset - 1) * 2;
    }

    public AcasState getAcasRA() {
        return this.acasRA;
    }

    public boolean isAcasIdent() {
        return this.acasIdent;
    }

    public boolean isSingleAntennaFlag() {
        return this.singleAntennaFlag;
    }

    public SourceIntegrityLevel getSystemDesignAssurance() {
        return this.systemDesignAssurance;
    }

    public boolean isGpsLateralOffsetAvailable() {
        return this.gpsLateralOffsetAvailable;
    }

    public int getGpsLateralOffset() {
        return this.gpsLateralOffset;
    }

    public boolean isGpsLongitudinalOffsetAvailable() {
        return this.gpsLongitudinalOffsetAvailable;
    }

    public boolean isGpsLongitudinalOffsetAppliedBySensor() {
        return this.gpsLongitudinalOffsetAppliedBySensor;
    }

    public int getGpsLongitudinalOffset() {
        return this.gpsLongitudinalOffset;
    }
}

