/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.api;

import org.springframework.context.ApplicationContext;
import org.springframework.security.access.expression.SecurityExpressionRoot;
import org.springframework.security.access.expression.method.MethodSecurityExpressionOperations;
import org.springframework.security.core.Authentication;
import org.springframework.util.StringUtils;

public class ApiSecurityExpressionRoot
extends SecurityExpressionRoot
implements MethodSecurityExpressionOperations {
    private Object filterObject;
    private boolean inDebugMode;
    private boolean isSecurityEnabled;
    private Object returnObject;

    public ApiSecurityExpressionRoot(Authentication authentication, ApplicationContext applicationContext) {
        super(authentication);
        try {
            if (StringUtils.hasText((String)applicationContext.getEnvironment().getProperty("inception.debug.enabled"))) {
                this.inDebugMode = Boolean.parseBoolean(applicationContext.getEnvironment().getProperty("inception.debug.enabled"));
            }
        }
        catch (Throwable e) {
            this.inDebugMode = false;
        }
        try {
            this.isSecurityEnabled = StringUtils.hasText((String)applicationContext.getEnvironment().getProperty("inception.api.security.enabled")) ? Boolean.parseBoolean(applicationContext.getEnvironment().getProperty("inception.api.security.enabled")) : !this.inDebugMode;
        }
        catch (Throwable e) {
            this.isSecurityEnabled = !this.inDebugMode;
        }
    }

    public Object getFilterObject() {
        return this.filterObject;
    }

    public Object getReturnObject() {
        return this.returnObject;
    }

    public Object getThis() {
        return this;
    }

    public boolean isSecurityDisabled() {
        return !this.isSecurityEnabled;
    }

    public boolean isSecurityEnabled() {
        return this.isSecurityEnabled;
    }

    public void setFilterObject(Object filterObject) {
        this.filterObject = filterObject;
    }

    public void setReturnObject(Object returnObject) {
        this.returnObject = returnObject;
    }
}

