/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.api;

import africa.absa.inception.core.service.ValidationError;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.LocalDateTime;
import java.util.List;

@Schema(description="A problem details object, as defined by RFC 7807, which holds the information for an error returned by an API")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"timestamp", "type", "title", "status", "detail", "parameter", "validationErrors", "stackTrace"})
public class ProblemDetails {
    @Schema(description="The human-readable explanation specific to this occurrence of the problem", required=true)
    @JsonProperty(required=true)
    private String detail;
    @Schema(description="The optional name of the parameter associated with the problem")
    @JsonProperty
    private String parameter;
    @Schema(description="The optional stack trace generated by the origin server for the problem")
    @JsonProperty
    private String stackTrace;
    @Schema(description="The HTTP status code generated by the origin server for this occurrence of the problem", required=true)
    @JsonProperty(required=true)
    private int status;
    @Schema(description="The date and time the problem occurred", required=true)
    @JsonProperty(required=true)
    private LocalDateTime timestamp;
    @Schema(description="The short, human-readable summary of the problem type; it should not change from occurrence to occurrence of the problem, except for purposes of localization", required=true)
    @JsonProperty(required=true)
    private String title;
    @Schema(description="The URI reference that identifies the problem type", required=true)
    @JsonProperty(required=true)
    private String type;
    @Schema(description="The optional validation errors associated with the problem")
    @JsonProperty
    private List<ValidationError> validationErrors;

    public String getDetail() {
        return this.detail;
    }

    public String getParameter() {
        return this.parameter;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public int getStatus() {
        return this.status;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public String getTitle() {
        return this.title;
    }

    public String getType() {
        return this.type;
    }

    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setTimestamp(LocalDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setValidationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
    }
}

