/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.api;

import africa.absa.inception.api.ProblemDetails;
import africa.absa.inception.core.service.InvalidArgumentException;
import africa.absa.inception.core.service.Problem;
import africa.absa.inception.core.service.ServiceException;
import africa.absa.inception.core.service.ServiceUnavailableException;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.time.LocalDateTime;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class ProblemHandler {
    private static final Logger logger = LoggerFactory.getLogger(ProblemHandler.class);
    @Value(value="${inception.debug.enabled:#{false}}")
    private boolean inDebugMode;

    @ExceptionHandler
    @ResponseBody
    protected ResponseEntity<ProblemDetails> handle(HttpServletRequest request, ServiceException serviceException) {
        if (this.inDebugMode) {
            logger.error("Failed to process the HTTP servlet request (" + request.getRequestURI() + ")", (Throwable)serviceException);
        }
        ProblemDetails problemDetails = new ProblemDetails();
        problemDetails.setTimestamp(serviceException.getTimestamp());
        Problem problem = (Problem)AnnotatedElementUtils.findMergedAnnotation(serviceException.getClass(), Problem.class);
        if (problem != null) {
            problemDetails.setType(problem.type());
            problemDetails.setTitle(problem.title());
            problemDetails.setStatus(problem.status());
        } else if (serviceException instanceof InvalidArgumentException) {
            problemDetails.setType("http://inception.absa.africa/problems/invalid-argument");
            problemDetails.setTitle("Invalid argument.");
            problemDetails.setStatus(HttpStatus.BAD_REQUEST.value());
            InvalidArgumentException invalidArgumentException = (InvalidArgumentException)serviceException;
            problemDetails.setParameter(invalidArgumentException.getParameter());
            problemDetails.setValidationErrors(invalidArgumentException.getValidationErrors());
        } else if (serviceException instanceof ServiceUnavailableException) {
            problemDetails.setType("http://inception.absa.africa/problems/service-unavailable");
            problemDetails.setTitle("An error has occurred and your request could not be processed at this time.");
            problemDetails.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        } else {
            problemDetails.setType("about:blank");
            problemDetails.setTitle("An error has occurred and your request could not be processed at this time.");
            problemDetails.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        }
        problemDetails.setDetail(serviceException.getMessage());
        if (this.inDebugMode) {
            logger.error(serviceException.getMessage(), (Throwable)serviceException);
            problemDetails.setStackTrace(this.dumpStackTrace((Throwable)serviceException));
        }
        return new ResponseEntity((Object)problemDetails, (MultiValueMap)new HttpHeaders(), problemDetails.getStatus());
    }

    @ExceptionHandler
    @ResponseBody
    protected ResponseEntity<ProblemDetails> handle(HttpServletRequest request, AccessDeniedException accessDeniedException) {
        ProblemDetails problemDetails = new ProblemDetails();
        problemDetails.setTimestamp(LocalDateTime.now());
        problemDetails.setType("http://inception.absa.africa/problems/access-denied");
        problemDetails.setTitle("Access denied.");
        problemDetails.setStatus(HttpStatus.FORBIDDEN.value());
        problemDetails.setDetail(accessDeniedException.getMessage());
        if (this.inDebugMode) {
            problemDetails.setStackTrace(this.dumpStackTrace((Throwable)accessDeniedException));
        }
        return new ResponseEntity((Object)problemDetails, (MultiValueMap)new HttpHeaders(), problemDetails.getStatus());
    }

    @ExceptionHandler
    @ResponseBody
    protected ResponseEntity<ProblemDetails> handle(HttpServletRequest request, Throwable cause) {
        if (this.inDebugMode) {
            logger.error("Failed to process the HTTP servlet request (" + request.getRequestURI() + ")", cause);
        }
        ProblemDetails problemDetails = new ProblemDetails();
        problemDetails.setTimestamp(LocalDateTime.now());
        problemDetails.setType("about:blank");
        problemDetails.setTitle("An error has occurred and your request could not be processed at this time.");
        problemDetails.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        problemDetails.setDetail(cause.getMessage());
        if (this.inDebugMode) {
            problemDetails.setStackTrace(this.dumpStackTrace(cause));
        }
        return new ResponseEntity((Object)problemDetails, (MultiValueMap)new HttpHeaders(), problemDetails.getStatus());
    }

    private String dumpStackTrace(Throwable throwable) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(baos);
            throwable.printStackTrace(pw);
            pw.flush();
            return baos.toString();
        }
        catch (Throwable e) {
            return "Failed to retrieve the exception stack trace: " + e.getMessage();
        }
    }
}

