/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StringUtils;

public abstract class SecureApi {
    private static final String ADMINISTRATOR_ROLE_CODE = "Administrator";
    private boolean inDebugMode;
    private boolean isSecurityEnabled;

    public SecureApi(ApplicationContext applicationContext) {
        try {
            if (StringUtils.hasText((String)applicationContext.getEnvironment().getProperty("inception.debug.enabled"))) {
                this.inDebugMode = Boolean.parseBoolean(applicationContext.getEnvironment().getProperty("inception.debug.enabled"));
            }
        }
        catch (Throwable e) {
            this.inDebugMode = false;
        }
        try {
            if (StringUtils.hasText((String)applicationContext.getEnvironment().getProperty("inception.api.security.enabled"))) {
                this.isSecurityEnabled = Boolean.parseBoolean(applicationContext.getEnvironment().getProperty("inception.api.security.enabled"));
            }
        }
        catch (Throwable e) {
            this.isSecurityEnabled = !this.inDebugMode;
        }
    }

    public boolean inDebugMode() {
        return this.inDebugMode;
    }

    public boolean isSecurityDisabled() {
        return !this.isSecurityEnabled;
    }

    public boolean isSecurityEnabled() {
        return this.isSecurityEnabled;
    }

    protected List<Long> getLongValuesForAuthoritiesWithPrefix(Authentication authentication, String prefix) {
        ArrayList<Long> values = new ArrayList<Long>();
        for (GrantedAuthority authority : authentication.getAuthorities()) {
            if (!authority.getAuthority().startsWith(prefix)) continue;
            try {
                values.add(Long.parseLong(authority.getAuthority().substring(prefix.length())));
            }
            catch (Throwable throwable) {}
        }
        return values;
    }

    protected List<UUID> getUUIDValuesForAuthoritiesWithPrefix(Authentication authentication, String prefix) {
        ArrayList<UUID> values = new ArrayList<UUID>();
        for (GrantedAuthority authority : authentication.getAuthorities()) {
            if (!authority.getAuthority().startsWith(prefix)) continue;
            try {
                values.add(UUID.fromString(authority.getAuthority().substring(prefix.length())));
            }
            catch (Throwable throwable) {}
        }
        return values;
    }

    protected Optional<String> getValueForAuthorityWithPrefix(Authentication authentication, String prefix) {
        for (GrantedAuthority authority : authentication.getAuthorities()) {
            if (!authority.getAuthority().startsWith(prefix)) continue;
            return Optional.of(authority.getAuthority().substring(prefix.length()));
        }
        return Optional.empty();
    }

    protected List<String> getValuesForAuthoritiesWithPrefix(Authentication authentication, String prefix) {
        ArrayList<String> values = new ArrayList<String>();
        for (GrantedAuthority authority : authentication.getAuthorities()) {
            if (!authority.getAuthority().startsWith(prefix)) continue;
            values.add(authority.getAuthority().substring(prefix.length()));
        }
        return values;
    }

    protected boolean hasAccessToFunction(String functionCode) {
        return this.hasAuthority("FUNCTION_" + functionCode);
    }

    protected boolean hasAccessToTenant(UUID tenantId) {
        if (this.isSecurityEnabled) {
            if (tenantId == null) {
                return false;
            }
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication == null) {
                return false;
            }
            if (!authentication.isAuthenticated()) {
                return false;
            }
            if (this.hasRole(ADMINISTRATOR_ROLE_CODE)) {
                return true;
            }
            List<UUID> tenantIds = this.getUUIDValuesForAuthoritiesWithPrefix(authentication, "TENANT_");
            return tenantIds.contains(tenantId);
        }
        return true;
    }

    protected boolean hasAuthority(String authority) {
        if (this.isSecurityEnabled) {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication == null) {
                return false;
            }
            if (!StringUtils.hasText((String)authority)) {
                return false;
            }
            if (!authentication.isAuthenticated()) {
                return false;
            }
            for (GrantedAuthority grantedAuthority : authentication.getAuthorities()) {
                if (!grantedAuthority.getAuthority().equalsIgnoreCase(authority)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean hasRole(String roleName) {
        return this.hasAuthority("ROLE_" + roleName);
    }
}

