/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.jta.agroal;

import africa.absa.inception.jta.util.XAExceptionUtil;
import io.agroal.api.transaction.TransactionAware;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class LocalXAResource
implements XAResource {
    private final TransactionAware transactionAware;
    private Xid currentXid;

    public LocalXAResource(TransactionAware transactionAware) {
        this.transactionAware = transactionAware;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (xid == null || !xid.equals(this.currentXid)) {
            throw XAExceptionUtil.xaException(-4, "Failed to commit the transaction (" + this.currentXid + ") for the transaction aware connection resource using the invalid xid (" + xid + ")");
        }
        this.currentXid = null;
        try {
            this.transactionAware.transactionBeforeCompletion(true);
            this.transactionAware.transactionCommit();
        }
        catch (Throwable e) {
            this.transactionAware.setFlushOnly();
            throw XAExceptionUtil.xaException(onePhase ? 100 : -3, "Failed to commit the transaction (" + xid + ") for the transaction aware connection resource: " + e.getMessage(), e);
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        if (xid == null || !xid.equals(this.currentXid)) {
            this.transactionAware.setFlushOnly();
            throw XAExceptionUtil.xaException(-4, "Failed to end the transaction (" + this.currentXid + ") for the transaction aware connection resource using the invalid xid (" + xid + ")");
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.transactionAware.setFlushOnly();
        throw XAExceptionUtil.xaException(-4, "Forget not supported for the transaction aware connection resource");
    }

    @Override
    public int getTransactionTimeout() {
        return 0;
    }

    @Override
    public boolean isSameRM(XAResource xaResource) {
        return this == xaResource;
    }

    @Override
    public int prepare(Xid xid) {
        return 0;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        this.transactionAware.setFlushOnly();
        throw XAExceptionUtil.xaException(-3, "Recover not supported for the transaction aware connection resource");
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        if (xid == null || !xid.equals(this.currentXid)) {
            throw XAExceptionUtil.xaException(-4, "Failed to rollback the transaction (" + this.currentXid + ") for the transaction aware connection resource using the invalid xid (" + xid + ")");
        }
        this.currentXid = null;
        try {
            this.transactionAware.transactionBeforeCompletion(false);
            this.transactionAware.transactionRollback();
        }
        catch (Throwable e) {
            this.transactionAware.setFlushOnly();
            throw XAExceptionUtil.xaException(-3, "Failed to rollback the transaction (" + xid + ") for the transaction aware connection resource: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean setTransactionTimeout(int seconds) {
        return false;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (this.currentXid == null) {
            if (flags != 0) {
                throw XAExceptionUtil.xaException(-5, "Failed to start the transaction (" + xid + ") for the transaction aware connection resource using the invalid flags (" + flags + ")");
            }
            try {
                this.transactionAware.transactionStart();
            }
            catch (Throwable e) {
                this.transactionAware.setFlushOnly();
                throw XAExceptionUtil.xaException(-3, "Failed to start the transaction (" + xid + ") for the transaction aware connection resource: " + e.getMessage(), e);
            }
            this.currentXid = xid;
        } else if (flags != 0x200000 && flags != 0x8000000) {
            throw XAExceptionUtil.xaException(-8, "Failed to join or resume the transaction (" + xid + ") for the transaction aware connection resource using the invalid flags (" + flags + ")");
        }
    }
}

