/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.jta.agroal;

import africa.absa.inception.jta.agroal.LocalXAResource;
import africa.absa.inception.jta.agroal.RecoveryXAResource;
import africa.absa.inception.jta.agroal.TransactionAwareXAResource;
import africa.absa.inception.jta.util.TransactionUtil;
import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.jta.recovery.XAResourceRecoveryHelper;
import io.agroal.api.transaction.TransactionAware;
import io.agroal.api.transaction.TransactionIntegration;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAResource;

public class NarayanaTransactionIntegration
implements TransactionIntegration {
    private static final ConcurrentMap<TransactionIntegration.ResourceRecoveryFactory, XAResourceRecoveryHelperImpl> xaResourceRecoveryHelperImplCache = new ConcurrentHashMap<TransactionIntegration.ResourceRecoveryFactory, XAResourceRecoveryHelperImpl>();
    private final UUID key = UUID.randomUUID();
    private final RecoveryManager recoveryManager;
    private final TransactionManager transactionManager;
    private final TransactionSynchronizationRegistry transactionSynchronizationRegistry;

    public NarayanaTransactionIntegration(TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        this(transactionManager, transactionSynchronizationRegistry, null);
    }

    public NarayanaTransactionIntegration(TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry, RecoveryManager recoveryManager) {
        this.transactionManager = transactionManager;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
        this.recoveryManager = recoveryManager;
    }

    public void addResourceRecoveryFactory(TransactionIntegration.ResourceRecoveryFactory resourceRecoveryFactory) {
        XARecoveryModule xaRecoveryModule = this.recoveryManager.getModules().stream().filter(recoveryModule -> recoveryModule instanceof XARecoveryModule).findFirst().orElse(null);
        if (xaRecoveryModule == null) {
            throw new IllegalStateException("Failed to retrieve the XARecoveryModule from the Narayana Recovery Manager");
        }
        xaRecoveryModule.addXAResourceRecoveryHelper((XAResourceRecoveryHelper)xaResourceRecoveryHelperImplCache.computeIfAbsent(resourceRecoveryFactory, rrf -> new XAResourceRecoveryHelperImpl(new RecoveryXAResource((TransactionIntegration.ResourceRecoveryFactory)rrf))));
    }

    public void associate(TransactionAware transactionAware, XAResource xaResource) throws SQLException {
        try {
            if (this.transactionRunning()) {
                if (this.transactionSynchronizationRegistry.getResource((Object)this.key) == null) {
                    this.transactionSynchronizationRegistry.registerInterposedSynchronization((Synchronization)new InterposedSynchronization(transactionAware));
                    this.transactionSynchronizationRegistry.putResource((Object)this.key, (Object)transactionAware);
                    XAResource xaResourceToEnlist = xaResource != null ? new TransactionAwareXAResource(transactionAware, xaResource) : new LocalXAResource(transactionAware);
                    this.transactionManager.getTransaction().enlistResource(xaResourceToEnlist);
                } else {
                    transactionAware.transactionStart();
                }
            }
            transactionAware.transactionCheckCallback(this::transactionRunning);
        }
        catch (Exception e) {
            throw new SQLException("Failed to associate the connection with an existing transaction", e);
        }
    }

    public boolean disassociate(TransactionAware transactionAware) {
        if (this.transactionRunning()) {
            this.transactionSynchronizationRegistry.putResource((Object)this.key, null);
        }
        return true;
    }

    public TransactionAware getTransactionAware() {
        if (this.transactionRunning()) {
            return (TransactionAware)this.transactionSynchronizationRegistry.getResource((Object)this.key);
        }
        return null;
    }

    public void removeResourceRecoveryFactory(TransactionIntegration.ResourceRecoveryFactory resourceRecoveryFactory) {
        XARecoveryModule xaRecoveryModule = this.recoveryManager.getModules().stream().filter(recoveryModule -> recoveryModule instanceof XARecoveryModule).findFirst().orElse(null);
        if (xaRecoveryModule == null) {
            throw new IllegalStateException("Failed to retrieve the XARecoveryModule from the Narayana Recovery Manager");
        }
        xaRecoveryModule.removeXAResourceRecoveryHelper((XAResourceRecoveryHelper)xaResourceRecoveryHelperImplCache.remove(resourceRecoveryFactory));
    }

    private boolean transactionRunning() {
        return TransactionUtil.transactionExists(this.transactionManager);
    }

    private static class InterposedSynchronization
    implements Synchronization {
        private final TransactionAware transactionAware;

        InterposedSynchronization(TransactionAware transactionAware) {
            this.transactionAware = transactionAware;
        }

        public void afterCompletion(int status) {
            try {
                this.transactionAware.transactionEnd();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void beforeCompletion() {
        }
    }

    private static class XAResourceRecoveryHelperImpl
    implements XAResourceRecoveryHelper {
        private final XAResource[] xaResources = new XAResource[1];

        public XAResourceRecoveryHelperImpl(XAResource xaResource) {
            this.xaResources[0] = xaResource;
        }

        public XAResource[] getXAResources() {
            return this.xaResources;
        }

        public boolean initialise(String p) {
            return true;
        }
    }
}

