/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.jta.agroal;

import africa.absa.inception.jta.util.XAExceptionUtil;
import io.agroal.api.transaction.TransactionIntegration;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class RecoveryXAResource
implements AutoCloseable,
XAResource {
    private final TransactionIntegration.ResourceRecoveryFactory resourceRecoveryFactory;
    private XAConnection xaConnection;
    private XAResource xaResource;

    public RecoveryXAResource(TransactionIntegration.ResourceRecoveryFactory resourceRecoveryFactory) {
        this.resourceRecoveryFactory = resourceRecoveryFactory;
    }

    @Override
    public void close() throws XAException {
        try {
            if (this.xaConnection != null) {
                this.xaConnection.close();
            }
        }
        catch (SQLException e) {
            XAExceptionUtil.xaException(-7, "Failed to close the XAConnection", e);
        }
        finally {
            this.xaConnection = null;
            this.xaResource = null;
        }
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.xaResource.commit(xid, onePhase);
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        this.xaResource.end(xid, flags);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.xaResource.forget(xid);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.xaResource.getTransactionTimeout();
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        if (xaResource instanceof RecoveryXAResource) {
            return this.xaResource.isSameRM(((RecoveryXAResource)xaResource).xaResource);
        }
        return this.xaResource.isSameRM(xaResource);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        return this.xaResource.prepare(xid);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        if (flag == 0x1000000) {
            try {
                this.xaConnection = this.resourceRecoveryFactory.getRecoveryConnection();
                this.xaResource = this.xaConnection.getXAResource();
            }
            catch (SQLException e) {
                XAExceptionUtil.xaException(-7, "Failed to retrieve the recovery XAConnection from the ResourceRecoveryFactory", e);
            }
        }
        if (this.xaConnection == null) {
            throw new XAException(-7);
        }
        Xid[] value = this.xaResource.recover(flag);
        if (flag == 0x800000 && (value == null || value.length == 0)) {
            this.close();
        }
        return value;
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.xaResource.rollback(xid);
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.xaResource.setTransactionTimeout(seconds);
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        this.xaResource.start(xid, flags);
    }
}

