/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.jta.agroal;

import africa.absa.inception.jta.util.XAExceptionUtil;
import io.agroal.api.transaction.TransactionAware;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class TransactionAwareXAResource
implements XAResource {
    private final TransactionAware transactionAware;
    private final XAResource xaResource;

    public TransactionAwareXAResource(TransactionAware transactionAware, XAResource xaResource) {
        this.transactionAware = transactionAware;
        this.xaResource = xaResource;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this.transactionAware.transactionBeforeCompletion(true);
            this.xaResource.commit(xid, onePhase);
        }
        catch (XAException e) {
            this.transactionAware.setFlushOnly();
            throw e;
        }
        catch (Throwable e) {
            this.transactionAware.setFlushOnly();
            throw XAExceptionUtil.xaException(onePhase ? 100 : -3, "Failed to commit the XA transaction (" + xid + ") for the XA resource: " + e.getMessage(), e);
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        try {
            this.xaResource.end(xid, flags);
        }
        catch (XAException e) {
            this.transactionAware.setFlushOnly();
            throw e;
        }
        catch (Throwable e) {
            this.transactionAware.setFlushOnly();
            throw XAExceptionUtil.xaException(-3, "Failed to end the transaction (" + xid + ") for the XA resource: " + e.getMessage(), e);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        try {
            this.xaResource.forget(xid);
        }
        catch (XAException e) {
            this.transactionAware.setFlushOnly();
            throw e;
        }
        catch (Throwable e) {
            this.transactionAware.setFlushOnly();
            throw XAExceptionUtil.xaException(-3, "Failed to forget the transaction (" + xid + ") for the XA resource: " + e.getMessage(), e);
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        try {
            return this.xaResource.getTransactionTimeout();
        }
        catch (XAException e) {
            this.transactionAware.setFlushOnly();
            throw e;
        }
        catch (Throwable e) {
            this.transactionAware.setFlushOnly();
            throw XAExceptionUtil.xaException(-3, "Failed to retrieve the transaction timeout for the XA resource: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        try {
            if (xaResource instanceof TransactionAwareXAResource) {
                return this.xaResource.isSameRM(((TransactionAwareXAResource)xaResource).xaResource);
            }
            return this.xaResource.isSameRM(xaResource);
        }
        catch (XAException e) {
            this.transactionAware.setFlushOnly();
            throw e;
        }
        catch (Throwable e) {
            this.transactionAware.setFlushOnly();
            throw XAExceptionUtil.xaException(-3, "Failed to determine whether the XA resource has the same resource manager: " + e.getMessage(), e);
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        try {
            return this.xaResource.prepare(xid);
        }
        catch (XAException e) {
            this.transactionAware.setFlushOnly();
            throw e;
        }
        catch (Throwable e) {
            this.transactionAware.setFlushOnly();
            throw XAExceptionUtil.xaException(-3, "Failed to prepare the transaction for the XA resource: " + e.getMessage(), e);
        }
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        try {
            return this.xaResource.recover(flag);
        }
        catch (XAException e) {
            this.transactionAware.setFlushOnly();
            throw e;
        }
        catch (Throwable e) {
            this.transactionAware.setFlushOnly();
            throw XAExceptionUtil.xaException(-3, "Failed to retrieve the list of prepared transaction branches from the resource manager for the XA resource: " + e.getMessage(), e);
        }
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        try {
            this.transactionAware.transactionBeforeCompletion(false);
            this.xaResource.rollback(xid);
        }
        catch (XAException e) {
            this.transactionAware.setFlushOnly();
            throw e;
        }
        catch (Throwable e) {
            this.transactionAware.setFlushOnly();
            throw XAExceptionUtil.xaException(-3, "Failed to rollback the transaction (" + xid + ") for the XA resource: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        try {
            return this.xaResource.setTransactionTimeout(seconds);
        }
        catch (XAException e) {
            this.transactionAware.setFlushOnly();
            throw e;
        }
        catch (Throwable e) {
            this.transactionAware.setFlushOnly();
            throw XAExceptionUtil.xaException(-3, "Failed to set the transaction timeout for the XA resource: " + e.getMessage(), e);
        }
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        try {
            this.transactionAware.transactionStart();
            this.xaResource.start(xid, flags);
        }
        catch (XAException e) {
            this.transactionAware.setFlushOnly();
            throw e;
        }
        catch (Throwable e) {
            this.transactionAware.setFlushOnly();
            throw XAExceptionUtil.xaException(-3, "Failed to start the transaction (" + xid + ") for the XA resource: " + e.getMessage(), e);
        }
    }
}

