/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.jta.narayana;

import africa.absa.inception.jta.agroal.NarayanaTransactionIntegration;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionSynchronizationRegistryImple;
import com.arjuna.ats.jta.TransactionManager;
import com.arjuna.ats.jta.UserTransaction;
import io.agroal.api.transaction.TransactionIntegration;
import java.net.InetAddress;
import javax.transaction.TransactionSynchronizationRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;

@Component
public class NarayanaFactory {
    private static String nodeName() {
        try {
            InetAddress localMachine = InetAddress.getLocalHost();
            return localMachine.getHostName().toLowerCase();
        }
        catch (Throwable e) {
            return "Unknown";
        }
    }

    @Bean
    public RecoveryManager narayanaRecoveryManager() {
        RecoveryManager recoveryManager = RecoveryManager.manager();
        recoveryManager.initialize();
        return RecoveryManager.manager();
    }

    @Bean
    public TransactionIntegration narayanaTransactionIntegration(javax.transaction.TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry, RecoveryManager recoveryManager) {
        return new NarayanaTransactionIntegration(transactionManager, transactionSynchronizationRegistry, recoveryManager);
    }

    @Bean
    public javax.transaction.TransactionManager narayanaTransactionManager() {
        return TransactionManager.transactionManager();
    }

    @Bean
    public TransactionSynchronizationRegistry narayanaTransactionSynchronizationRegistry(javax.transaction.TransactionManager transactionManager) {
        return new TransactionSynchronizationRegistryImple();
    }

    @Bean
    public javax.transaction.UserTransaction narayanaUserTransaction() {
        return UserTransaction.userTransaction();
    }

    @Bean
    public PlatformTransactionManager transactionManager(javax.transaction.UserTransaction userTransaction, javax.transaction.TransactionManager transactionManager) {
        try {
            return new JtaTransactionManager(userTransaction, transactionManager);
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to initialize the JTA transaction manager");
        }
    }

    static {
        TxControl.setXANodeName((String)NarayanaFactory.nodeName());
    }
}

