/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.mail;

import africa.absa.inception.mail.IMailService;
import africa.absa.inception.mail.MailTemplate;
import africa.absa.inception.mail.MailTemplateNotFoundException;
import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;

public class FreeMarkerTemplateLoader
implements TemplateLoader {
    private final IMailService mailService;

    public FreeMarkerTemplateLoader(IMailService mailService) {
        this.mailService = mailService;
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
    }

    public Object findTemplateSource(String name) throws IOException {
        try {
            MailTemplate mailTemplate = this.mailService.getMailTemplate(name);
            return mailTemplate.getId();
        }
        catch (MailTemplateNotFoundException e) {
            return null;
        }
        catch (Throwable e) {
            throw new IOException("Failed to find the template source (" + name + ")", e);
        }
    }

    public long getLastModified(Object templateSource) {
        try {
            if (templateSource instanceof String) {
                MailTemplate mailTemplate = this.mailService.getMailTemplate((String)templateSource);
                return mailTemplate.getUpdated().toInstant(ZoneOffset.UTC).toEpochMilli();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1L;
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        try {
            if (templateSource instanceof String) {
                MailTemplate mailTemplate = this.mailService.getMailTemplate((String)templateSource);
                return new StringReader(new String(mailTemplate.getTemplate(), StandardCharsets.UTF_8));
            }
            throw new RuntimeException("Invalid template source (" + templateSource + ")");
        }
        catch (Throwable e) {
            throw new IOException("Failed to retrieve the character stream for the template (" + templateSource + ")", e);
        }
    }
}

