/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.mail;

import africa.absa.inception.core.service.InvalidArgumentException;
import africa.absa.inception.core.service.ServiceUnavailableException;
import africa.absa.inception.core.service.ValidationError;
import africa.absa.inception.mail.DuplicateMailTemplateException;
import africa.absa.inception.mail.FreeMarkerTemplateLoader;
import africa.absa.inception.mail.IMailService;
import africa.absa.inception.mail.MailTemplate;
import africa.absa.inception.mail.MailTemplateContentType;
import africa.absa.inception.mail.MailTemplateNotFoundException;
import africa.absa.inception.mail.MailTemplateRepository;
import africa.absa.inception.mail.MailTemplateSummary;
import africa.absa.inception.mail.MailTemplateSummaryRepository;
import freemarker.cache.TemplateLoader;
import freemarker.cache.TemplateLookupContext;
import freemarker.cache.TemplateLookupResult;
import freemarker.cache.TemplateLookupStrategy;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.ApplicationContext;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class MailService
implements IMailService,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(MailService.class);
    private final ApplicationContext applicationContext;
    private final Configuration freeMarkerConfiguration;
    private final MailTemplateRepository mailTemplateRepository;
    private final MailTemplateSummaryRepository mailTemplateSummaryRepository;
    private final Validator validator;
    private JavaMailSender javaMailSender;

    public MailService(ApplicationContext applicationContext, Validator validator, MailTemplateRepository mailTemplateRepository, MailTemplateSummaryRepository mailTemplateSummaryRepository) {
        this.applicationContext = applicationContext;
        this.validator = validator;
        this.mailTemplateRepository = mailTemplateRepository;
        this.mailTemplateSummaryRepository = mailTemplateSummaryRepository;
        this.freeMarkerConfiguration = new Configuration(Configuration.VERSION_2_3_29);
        this.freeMarkerConfiguration.setTemplateLoader((TemplateLoader)new FreeMarkerTemplateLoader(this));
        this.freeMarkerConfiguration.setTemplateLookupStrategy(new TemplateLookupStrategy(){

            public TemplateLookupResult lookup(TemplateLookupContext templateLookupContext) throws IOException {
                return templateLookupContext.lookupWithAcquisitionStrategy(templateLookupContext.getTemplateName());
            }

            public String toString() {
                return "MailServiceLookupStrategy";
            }
        });
    }

    public void afterPropertiesSet() {
        try {
            this.javaMailSender = (JavaMailSender)this.applicationContext.getBean(JavaMailSender.class);
        }
        catch (NoSuchBeanDefinitionException ignored) {
            logger.warn("No JavaMailSender implementation found");
        }
    }

    @Override
    @Transactional
    @CachePut(cacheNames={"mailTemplates"}, key="#mailTemplate.id")
    public MailTemplate createMailTemplate(MailTemplate mailTemplate) throws InvalidArgumentException, DuplicateMailTemplateException, ServiceUnavailableException {
        this.validateMailTemplate(mailTemplate);
        try {
            if (this.mailTemplateRepository.existsById(mailTemplate.getId())) {
                throw new DuplicateMailTemplateException(mailTemplate.getId());
            }
            this.mailTemplateRepository.saveAndFlush(mailTemplate);
            return mailTemplate;
        }
        catch (DuplicateMailTemplateException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to create the mail template (" + mailTemplate.getId() + ")", e);
        }
    }

    @Override
    @Transactional
    @CacheEvict(cacheNames={"mailTemplates"}, key="#mailTemplateId")
    public void deleteMailTemplate(String mailTemplateId) throws InvalidArgumentException, MailTemplateNotFoundException, ServiceUnavailableException {
        if (!StringUtils.hasText((String)mailTemplateId)) {
            throw new InvalidArgumentException("mailTemplateId");
        }
        try {
            if (!this.mailTemplateRepository.existsById(mailTemplateId)) {
                throw new MailTemplateNotFoundException(mailTemplateId);
            }
            this.mailTemplateRepository.deleteById(mailTemplateId);
            this.freeMarkerConfiguration.clearTemplateCache();
        }
        catch (MailTemplateNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to delete the mail template (" + mailTemplateId + ")", e);
        }
    }

    @Override
    @Cacheable(cacheNames={"mailTemplates"}, key="#mailTemplateId")
    public MailTemplate getMailTemplate(String mailTemplateId) throws InvalidArgumentException, MailTemplateNotFoundException, ServiceUnavailableException {
        if (!StringUtils.hasText((String)mailTemplateId)) {
            throw new InvalidArgumentException("mailTemplateId");
        }
        try {
            Optional mailTemplateOptional = this.mailTemplateRepository.findById(mailTemplateId);
            if (mailTemplateOptional.isPresent()) {
                return (MailTemplate)mailTemplateOptional.get();
            }
            throw new MailTemplateNotFoundException(mailTemplateId);
        }
        catch (MailTemplateNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the mail template (" + mailTemplateId + ")", e);
        }
    }

    @Override
    public String getMailTemplateName(String mailTemplateId) throws InvalidArgumentException, MailTemplateNotFoundException, ServiceUnavailableException {
        if (!StringUtils.hasText((String)mailTemplateId)) {
            throw new InvalidArgumentException("mailTemplateId");
        }
        try {
            Optional<String> nameOptional = this.mailTemplateRepository.getNameById(mailTemplateId);
            if (nameOptional.isPresent()) {
                return nameOptional.get();
            }
            throw new MailTemplateNotFoundException(mailTemplateId);
        }
        catch (MailTemplateNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the name of the mail template (" + mailTemplateId + ")", e);
        }
    }

    @Override
    public List<MailTemplateSummary> getMailTemplateSummaries() throws ServiceUnavailableException {
        try {
            return this.mailTemplateSummaryRepository.findAll();
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the summaries for the mail templates", e);
        }
    }

    @Override
    public MailTemplateSummary getMailTemplateSummary(String mailTemplateId) throws InvalidArgumentException, MailTemplateNotFoundException, ServiceUnavailableException {
        if (!StringUtils.hasText((String)mailTemplateId)) {
            throw new InvalidArgumentException("mailTemplateId");
        }
        try {
            Optional mailTemplateSummaryOptional = this.mailTemplateSummaryRepository.findById(mailTemplateId);
            if (mailTemplateSummaryOptional.isPresent()) {
                return (MailTemplateSummary)mailTemplateSummaryOptional.get();
            }
            throw new MailTemplateNotFoundException(mailTemplateId);
        }
        catch (MailTemplateNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the summary for the mail template (" + mailTemplateId + ")", e);
        }
    }

    @Override
    public LocalDateTime getMailTemplateUpdated(String mailTemplateId) throws InvalidArgumentException, MailTemplateNotFoundException, ServiceUnavailableException {
        if (!StringUtils.hasText((String)mailTemplateId)) {
            throw new InvalidArgumentException("mailTemplateId");
        }
        try {
            Optional<LocalDateTime> updatedOptional = this.mailTemplateRepository.getUpdatedById(mailTemplateId);
            if (updatedOptional.isPresent()) {
                return updatedOptional.get();
            }
            throw new MailTemplateNotFoundException(mailTemplateId);
        }
        catch (MailTemplateNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the date and time the mail template (" + mailTemplateId + ") was last updated", e);
        }
    }

    @Override
    public List<MailTemplate> getMailTemplates() throws ServiceUnavailableException {
        try {
            return this.mailTemplateRepository.findAll();
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the mail templates", e);
        }
    }

    @Override
    public boolean mailTemplateExists(String mailTemplateId) throws InvalidArgumentException, ServiceUnavailableException {
        if (!StringUtils.hasText((String)mailTemplateId)) {
            throw new InvalidArgumentException("mailTemplateId");
        }
        try {
            return this.mailTemplateRepository.existsById(mailTemplateId);
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to check whether the mail template (" + mailTemplateId + ") exists", e);
        }
    }

    @Override
    public String processMailTemplate(String mailTemplateId, Map<String, String> templateParameters) throws InvalidArgumentException, ServiceUnavailableException {
        if (!StringUtils.hasText((String)mailTemplateId)) {
            throw new InvalidArgumentException("mailTemplateId");
        }
        if (templateParameters == null) {
            throw new InvalidArgumentException("templateParameters");
        }
        try {
            Template template = this.freeMarkerConfiguration.getTemplate(mailTemplateId);
            StringWriter sw = new StringWriter();
            template.process(templateParameters, (Writer)sw);
            return sw.toString();
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to process the mail template (" + mailTemplateId + ")", e);
        }
    }

    @Override
    public void sendMail(List<String> to, String subject, String from, String fromName, String mailTemplateId, Map<String, String> mailTemplateParameters) throws InvalidArgumentException, MailTemplateNotFoundException, ServiceUnavailableException {
        if (to == null) {
            throw new InvalidArgumentException("to");
        }
        if (!StringUtils.hasText((String)subject)) {
            throw new InvalidArgumentException("subject");
        }
        if (!StringUtils.hasText((String)from)) {
            throw new InvalidArgumentException("from");
        }
        if (!StringUtils.hasText((String)fromName)) {
            throw new InvalidArgumentException("fromName");
        }
        if (!StringUtils.hasText((String)mailTemplateId)) {
            throw new InvalidArgumentException("mailTemplateId");
        }
        if (mailTemplateParameters == null) {
            throw new InvalidArgumentException("mailTemplateParameters");
        }
        try {
            Optional mailTemplateOptional = this.mailTemplateRepository.findById(mailTemplateId);
            if (mailTemplateOptional.isEmpty()) {
                throw new MailTemplateNotFoundException(mailTemplateId);
            }
            MailTemplate mailTemplate = (MailTemplate)mailTemplateOptional.get();
            if (this.javaMailSender == null) {
                throw new ServiceUnavailableException("No JavaMailSender bean has been configured");
            }
            MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true);
            helper.setFrom(new InternetAddress(from, fromName));
            helper.setTo(to.toArray(new String[0]));
            helper.setSubject(subject);
            helper.setText(this.processMailTemplate(mailTemplate.getId(), mailTemplateParameters), mailTemplate.getContentType() == MailTemplateContentType.HTML);
            this.javaMailSender.send(helper.getMimeMessage());
        }
        catch (MailTemplateNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to send the mail", e);
        }
    }

    @Override
    @Transactional
    @CachePut(cacheNames={"mailTemplates"}, key="#mailTemplate.id")
    public MailTemplate updateMailTemplate(MailTemplate mailTemplate) throws InvalidArgumentException, MailTemplateNotFoundException, ServiceUnavailableException {
        this.validateMailTemplate(mailTemplate);
        try {
            if (!this.mailTemplateRepository.existsById(mailTemplate.getId())) {
                throw new MailTemplateNotFoundException(mailTemplate.getId());
            }
            this.mailTemplateRepository.saveAndFlush(mailTemplate);
            this.freeMarkerConfiguration.clearTemplateCache();
            return mailTemplate;
        }
        catch (MailTemplateNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to update the mail template (" + mailTemplate.getId() + ")", e);
        }
    }

    private void validateMailTemplate(MailTemplate mailTemplate) throws InvalidArgumentException {
        if (mailTemplate == null) {
            throw new InvalidArgumentException("mailTemplate");
        }
        Set constraintViolations = this.validator.validate((Object)mailTemplate, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            throw new InvalidArgumentException("mailTemplate", ValidationError.toValidationErrors((Set)constraintViolations));
        }
    }
}

