/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.mail;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="The mail template content type")
public enum MailTemplateContentType {
    TEXT("text", "Text"),
    HTML("html", "HTML");

    private final String code;
    private final String description;

    private MailTemplateContentType(String code, String description) {
        this.code = code;
        this.description = description;
    }

    @JsonCreator
    public static MailTemplateContentType fromCode(String code) {
        switch (code) {
            case "text": {
                return TEXT;
            }
            case "html": {
                return HTML;
            }
        }
        throw new RuntimeException("Failed to determine the mail template content type with the invalid code (" + code + ")");
    }

    public static MailTemplateContentType fromNumericCode(int numericCode) {
        switch (numericCode) {
            case 1: {
                return TEXT;
            }
            case 2: {
                return HTML;
            }
        }
        throw new RuntimeException("Failed to determine the mail template content type for the numeric code (" + numericCode + ")");
    }

    public static int toNumericCode(MailTemplateContentType mailTemplateContentType) {
        switch (mailTemplateContentType) {
            case TEXT: {
                return 1;
            }
            case HTML: {
                return 2;
            }
        }
        throw new RuntimeException("Failed to determine the numeric code for the mail template content type (" + mailTemplateContentType.code() + ")");
    }

    @JsonValue
    public String code() {
        return this.code;
    }

    public String description() {
        return this.description;
    }
}

