/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.reporting;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Schema(description="A report definition")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "name", "template"})
@Entity
@Table(schema="reporting", name="report_definitions")
public class ReportDefinition
implements Serializable {
    private static final long serialVersionUID = 1000000L;
    @JsonIgnore
    @Column(name="created", nullable=false, updatable=false)
    private LocalDateTime created;
    @Schema(description="The ID for the report definition", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Size(min=1, max=100)
    @Id
    @Column(name="id", length=100, nullable=false)
    private @NotNull @Size(min=1, max=100) String id;
    @Schema(description="The name of the report definition", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Size(min=1, max=100)
    @Column(name="name", length=100, nullable=false)
    private @NotNull @Size(min=1, max=100) String name;
    @Schema(description="The JasperReports template for the report definition", required=true)
    @JsonProperty(required=true)
    @NotNull
    @Size(min=1, max=0xA00000)
    @Column(name="template", nullable=false)
    private @NotNull @Size(min=1, max=0xA00000) byte[] template;
    @JsonIgnore
    @Column(name="updated", insertable=false)
    private LocalDateTime updated;

    public ReportDefinition() {
    }

    public ReportDefinition(String id, String name, byte[] template) {
        this.id = id;
        this.name = name;
        this.template = template;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ReportDefinition other = (ReportDefinition)object;
        return Objects.equals(this.id, other.id);
    }

    public LocalDateTime getCreated() {
        return this.created;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getTemplate() {
        return this.template;
    }

    public LocalDateTime getUpdated() {
        return this.updated;
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTemplate(byte[] template) {
        this.template = template;
    }

    public String toString() {
        return "ReportDefinition {id=\"" + this.getId() + "\", name=\"" + this.getName() + "\"}";
    }

    @PrePersist
    protected void onCreate() {
        this.created = LocalDateTime.now();
    }

    @PreUpdate
    protected void onUpdate() {
        this.updated = LocalDateTime.now();
    }
}

