/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.reporting;

import africa.absa.inception.core.service.InvalidArgumentException;
import africa.absa.inception.core.service.ServiceUnavailableException;
import africa.absa.inception.core.service.ValidationError;
import africa.absa.inception.reporting.DuplicateReportDefinitionException;
import africa.absa.inception.reporting.IReportingService;
import africa.absa.inception.reporting.ReportDefinition;
import africa.absa.inception.reporting.ReportDefinitionNotFoundException;
import africa.absa.inception.reporting.ReportDefinitionRepository;
import africa.absa.inception.reporting.ReportDefinitionSummary;
import africa.absa.inception.reporting.ReportDefinitionSummaryRepository;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.sql.DataSource;
import javax.validation.Validator;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;

@Service
public class ReportingService
implements IReportingService {
    private static final Logger logger = LoggerFactory.getLogger(ReportingService.class);
    private final DataSource dataSource;
    private final ReportDefinitionRepository reportDefinitionRepository;
    private final ReportDefinitionSummaryRepository reportDefinitionSummaryRepository;
    private final Validator validator;
    private String localReportFolderPath;

    public ReportingService(Validator validator, @Qualifier(value="applicationDataSource") DataSource dataSource, ReportDefinitionRepository reportDefinitionRepository, ReportDefinitionSummaryRepository reportDefinitionSummaryRepository) {
        this.validator = validator;
        this.dataSource = dataSource;
        this.reportDefinitionRepository = reportDefinitionRepository;
        this.reportDefinitionSummaryRepository = reportDefinitionSummaryRepository;
    }

    @Override
    @Transactional
    public void createReportDefinition(ReportDefinition reportDefinition) throws InvalidArgumentException, DuplicateReportDefinitionException, ServiceUnavailableException {
        this.validateReportDefinition(reportDefinition);
        try {
            if (this.reportDefinitionRepository.existsById(reportDefinition.getId())) {
                throw new DuplicateReportDefinitionException(reportDefinition.getId());
            }
            this.reportDefinitionRepository.saveAndFlush(reportDefinition);
        }
        catch (DuplicateReportDefinitionException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to create the report definition (" + reportDefinition.getId() + ")", e);
        }
    }

    @Override
    public byte[] createReportPDF(String reportDefinitionId, Map<String, Object> parameters) throws InvalidArgumentException, ReportDefinitionNotFoundException, ServiceUnavailableException {
        byte[] byArray;
        block11: {
            if (!StringUtils.hasText((String)reportDefinitionId)) {
                throw new InvalidArgumentException("reportDefinitionId");
            }
            if (parameters == null) {
                throw new InvalidArgumentException("parameters");
            }
            Connection connection = this.dataSource.getConnection();
            try {
                byArray = this.createReportPDF(reportDefinitionId, parameters, connection);
                if (connection == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReportDefinitionNotFoundException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new ServiceUnavailableException("Failed to create the PDF for the report using the report definition (" + reportDefinitionId + ")", e);
                }
            }
            connection.close();
        }
        return byArray;
    }

    @Override
    public byte[] createReportPDF(String reportDefinitionId, Map<String, Object> parameters, Connection connection) throws InvalidArgumentException, ReportDefinitionNotFoundException, ServiceUnavailableException {
        if (!StringUtils.hasText((String)reportDefinitionId)) {
            throw new InvalidArgumentException("reportDefinitionId");
        }
        if (parameters == null) {
            throw new InvalidArgumentException("parameters");
        }
        if (connection == null) {
            throw new InvalidArgumentException("connection");
        }
        try {
            Optional reportDefinitionOptional = this.reportDefinitionRepository.findById(reportDefinitionId);
            if (reportDefinitionOptional.isEmpty()) {
                throw new ReportDefinitionNotFoundException(reportDefinitionId);
            }
            HashMap<String, Object> localParameters = new HashMap<String, Object>();
            if (!StringUtils.hasText((String)this.getLocalReportFolderPath())) {
                localParameters.put("SUBREPORT_DIR", this.getLocalReportFolderPath());
            }
            for (String name : parameters.keySet()) {
                localParameters.put(name, parameters.get(name));
            }
            JasperPrint jasperPrint = JasperFillManager.fillReport((InputStream)new ByteArrayInputStream(((ReportDefinition)reportDefinitionOptional.get()).getTemplate()), localParameters, (Connection)connection);
            return JasperExportManager.exportReportToPdf((JasperPrint)jasperPrint);
        }
        catch (ReportDefinitionNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to create the PDF for the report using the report definition (" + reportDefinitionId + ")", e);
        }
    }

    @Override
    public byte[] createReportPDF(String reportDefinitionId, Map<String, Object> parameters, Document document) throws InvalidArgumentException, ReportDefinitionNotFoundException, ServiceUnavailableException {
        if (!StringUtils.hasText((String)reportDefinitionId)) {
            throw new InvalidArgumentException("reportDefinitionId");
        }
        if (parameters == null) {
            throw new InvalidArgumentException("parameters");
        }
        if (document == null) {
            throw new InvalidArgumentException("document");
        }
        try {
            ReportDefinition reportDefinition = this.getReportDefinition(reportDefinitionId);
            HashMap<String, Object> localParameters = new HashMap<String, Object>();
            localParameters.put("XML_DATA_DOCUMENT", document);
            localParameters.put("XML_DATE_PATTERN", "yyyy-MM-dd");
            localParameters.put("XML_NUMBER_PATTERN", "#,##0.##");
            localParameters.put("XML_LOCALE", Locale.ENGLISH);
            localParameters.put("REPORT_LOCALE", Locale.US);
            if (!StringUtils.hasText((String)this.getLocalReportFolderPath())) {
                localParameters.put("SUBREPORT_DIR", this.getLocalReportFolderPath());
            }
            for (String name : parameters.keySet()) {
                localParameters.put(name, parameters.get(name));
            }
            JasperPrint jasperPrint = JasperFillManager.fillReport((InputStream)new ByteArrayInputStream(reportDefinition.getTemplate()), localParameters);
            return JasperExportManager.exportReportToPdf((JasperPrint)jasperPrint);
        }
        catch (ReportDefinitionNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to create the PDF for the report using the report definintion (" + reportDefinitionId + ")", e);
        }
    }

    @Override
    @Transactional
    public void deleteReportDefinition(String reportDefinitionId) throws InvalidArgumentException, ReportDefinitionNotFoundException, ServiceUnavailableException {
        if (!StringUtils.hasText((String)reportDefinitionId)) {
            throw new InvalidArgumentException("reportDefinitionId");
        }
        try {
            if (!this.reportDefinitionRepository.existsById(reportDefinitionId)) {
                throw new ReportDefinitionNotFoundException(reportDefinitionId);
            }
            this.reportDefinitionRepository.deleteById(reportDefinitionId);
        }
        catch (ReportDefinitionNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to delete the report definition (" + reportDefinitionId + ")", e);
        }
    }

    @Override
    public String getLocalReportFolderPath() {
        return this.localReportFolderPath;
    }

    @Override
    public ReportDefinition getReportDefinition(String reportDefinitionId) throws InvalidArgumentException, ReportDefinitionNotFoundException, ServiceUnavailableException {
        if (!StringUtils.hasText((String)reportDefinitionId)) {
            throw new InvalidArgumentException("reportDefinitionId");
        }
        try {
            Optional reportDefinitionOptional = this.reportDefinitionRepository.findById(reportDefinitionId);
            if (reportDefinitionOptional.isPresent()) {
                return (ReportDefinition)reportDefinitionOptional.get();
            }
            throw new ReportDefinitionNotFoundException(reportDefinitionId);
        }
        catch (ReportDefinitionNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the report definition (" + reportDefinitionId + ")", e);
        }
    }

    @Override
    public String getReportDefinitionName(String reportDefinitionId) throws InvalidArgumentException, ReportDefinitionNotFoundException, ServiceUnavailableException {
        if (!StringUtils.hasText((String)reportDefinitionId)) {
            throw new InvalidArgumentException("reportDefinitionId");
        }
        try {
            Optional<String> nameOptional = this.reportDefinitionRepository.getNameById(reportDefinitionId);
            if (nameOptional.isPresent()) {
                return nameOptional.get();
            }
            throw new ReportDefinitionNotFoundException(reportDefinitionId);
        }
        catch (ReportDefinitionNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the name of the report definition (" + reportDefinitionId + ")", e);
        }
    }

    @Override
    public List<ReportDefinitionSummary> getReportDefinitionSummaries() throws ServiceUnavailableException {
        try {
            return this.reportDefinitionSummaryRepository.findAll();
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the summaries for the report definitions", e);
        }
    }

    @Override
    public ReportDefinitionSummary getReportDefinitionSummary(String reportDefinitionId) throws InvalidArgumentException, ReportDefinitionNotFoundException, ServiceUnavailableException {
        if (!StringUtils.hasText((String)reportDefinitionId)) {
            throw new InvalidArgumentException("reportDefinitionId");
        }
        try {
            Optional reportDefinitionSummaryOptional = this.reportDefinitionSummaryRepository.findById(reportDefinitionId);
            if (reportDefinitionSummaryOptional.isPresent()) {
                return (ReportDefinitionSummary)reportDefinitionSummaryOptional.get();
            }
            throw new ReportDefinitionNotFoundException(reportDefinitionId);
        }
        catch (ReportDefinitionNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the summary for the report definition (" + reportDefinitionId + ")", e);
        }
    }

    @Override
    public List<ReportDefinition> getReportDefinitions() throws ServiceUnavailableException {
        try {
            return this.reportDefinitionRepository.findAll();
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to retrieve the report definitions", e);
        }
    }

    @Override
    public boolean reportDefinitionExists(String reportDefinitionId) throws InvalidArgumentException, ServiceUnavailableException {
        if (!StringUtils.hasText((String)reportDefinitionId)) {
            throw new InvalidArgumentException("reportDefinitionId");
        }
        try {
            return this.reportDefinitionRepository.existsById(reportDefinitionId);
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to check whether the report definition (" + reportDefinitionId + ") exists", e);
        }
    }

    @Override
    public void setLocalReportFolderPath(String localReportFolderPath) {
        this.localReportFolderPath = localReportFolderPath;
    }

    @Override
    @Transactional
    public void updateReportDefinition(ReportDefinition reportDefinition) throws InvalidArgumentException, ReportDefinitionNotFoundException, ServiceUnavailableException {
        this.validateReportDefinition(reportDefinition);
        try {
            if (!this.reportDefinitionRepository.existsById(reportDefinition.getId())) {
                throw new ReportDefinitionNotFoundException(reportDefinition.getId());
            }
            this.reportDefinitionRepository.saveAndFlush(reportDefinition);
        }
        catch (ReportDefinitionNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceUnavailableException("Failed to update the report definition (" + reportDefinition.getId() + ")", e);
        }
    }

    private void validateReportDefinition(ReportDefinition reportDefinition) throws InvalidArgumentException {
        if (reportDefinition == null) {
            throw new InvalidArgumentException("reportDefinition");
        }
        Set constraintViolations = this.validator.validate((Object)reportDefinition, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            throw new InvalidArgumentException("reportDefinition", ValidationError.toValidationErrors((Set)constraintViolations));
        }
    }
}

