/*
 * Decompiled with CFR 0.152.
 */
package ag.granular.tiff;

import ag.granular.io.ByteBuffer;
import ag.granular.tiff.FieldTagType;
import ag.granular.tiff.FieldType;
import ag.granular.tiff.FileDirectory$WhenMappings;
import ag.granular.tiff.FileDirectoryEntry;
import ag.granular.tiff.FileDirectoryKt;
import ag.granular.tiff.ImageWindow;
import ag.granular.tiff.Rasters;
import ag.granular.tiff.TypedRasters;
import ag.granular.tiff.TypedSample;
import ag.granular.tiff.compression.CompressionDecoder;
import ag.granular.tiff.compression.DeflateCompression;
import ag.granular.tiff.compression.LZWCompression;
import ag.granular.tiff.compression.PackbitsCompression;
import ag.granular.tiff.compression.RawCompression;
import ag.granular.tiff.io.ByteReader;
import ag.granular.tiff.util.TiffException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b#\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b+\u0018\u00002\u00020\u0001B-\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020\u0004J\u0016\u0010`\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010a\u001a\u00020\rH\u0002J\u0016\u0010b\u001a\b\u0012\u0004\u0012\u00020L0\f2\u0006\u0010a\u001a\u00020LH\u0002J\u0011\u0010c\u001a\u00020\u00042\u0006\u0010d\u001a\u00020%H\u0086\u0002J\f\u0010e\u001a\b\u0012\u0004\u0012\u00020\u00040fJ\u001b\u0010g\u001a\u0002Hh\"\u0004\b\u0000\u0010h2\u0006\u0010d\u001a\u00020%H\u0002\u00a2\u0006\u0002\u0010iJ\u0012\u0010j\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u00040kJ\u000e\u0010l\u001a\u00020m2\u0006\u0010n\u001a\u00020\rJ\u000e\u0010o\u001a\u00020\r2\u0006\u0010d\u001a\u00020%J\u0016\u0010p\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010d\u001a\u00020%J\u0016\u0010q\u001a\n\u0012\u0004\u0012\u00020L\u0018\u00010\f2\u0006\u0010d\u001a\u00020%J\u0015\u0010r\u001a\u0004\u0018\u00010\r2\u0006\u0010d\u001a\u00020%\u00a2\u0006\u0002\u0010sJ\u000e\u0010t\u001a\u00020(2\u0006\u0010d\u001a\u00020%J\u0016\u0010u\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010\f2\u0006\u0010d\u001a\u00020%J\r\u0010v\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010w\u001a\u00020\r2\u0006\u0010n\u001a\u00020\rH\u0002J\u0010\u0010x\u001a\u0004\u0018\u00010y2\u0006\u0010d\u001a\u00020%J \u0010z\u001a\u00020\u00172\u0006\u0010{\u001a\u00020\r2\u0006\u0010|\u001a\u00020\r2\u0006\u0010}\u001a\u00020\rH\u0002J\u0006\u0010~\u001a\u00020\rJ\u0006\u0010\u007f\u001a\u00020RJ\u001e\u0010\u007f\u001a\u00020R2\b\u0010\u0080\u0001\u001a\u00030\u0081\u00012\f\b\u0002\u0010\u0082\u0001\u001a\u0005\u0018\u00010\u0083\u0001J\u0010\u0010\u007f\u001a\u00020R2\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001J&\u0010\u0084\u0001\u001a\u00020^2\b\u0010\u0080\u0001\u001a\u00030\u0081\u00012\b\u0010\u0082\u0001\u001a\u00030\u0083\u00012\u0007\u0010\u0085\u0001\u001a\u00020RH\u0002J\u0007\u0010\u0086\u0001\u001a\u00020RJ#\u0010\u0086\u0001\u001a\u00020R2\b\u0010\u0080\u0001\u001a\u00030\u0081\u00012\u0007\u0010\u0087\u0001\u001a\u00020\t2\u0007\u0010\u0088\u0001\u001a\u00020\tJ5\u0010\u0086\u0001\u001a\u00020R2\b\u0010\u0080\u0001\u001a\u00030\u0081\u00012\f\b\u0002\u0010\u0082\u0001\u001a\u0005\u0018\u00010\u0083\u00012\t\b\u0002\u0010\u0087\u0001\u001a\u00020\t2\t\b\u0002\u0010\u0088\u0001\u001a\u00020\tJ\u0019\u0010\u0086\u0001\u001a\u00020R2\u0007\u0010\u0087\u0001\u001a\u00020\t2\u0007\u0010\u0088\u0001\u001a\u00020\tJ\u0011\u0010\u0086\u0001\u001a\u00020R2\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001J#\u0010\u0086\u0001\u001a\u00020R2\b\u0010\u0082\u0001\u001a\u00030\u0083\u00012\u0007\u0010\u0087\u0001\u001a\u00020\t2\u0007\u0010\u0088\u0001\u001a\u00020\tJ\b\u0010\u0089\u0001\u001a\u00030\u008a\u0001J\u001a\u0010\u008b\u0001\u001a\u00020(2\u0006\u0010\u0006\u001a\u00020\u00072\u0007\u0010\u008c\u0001\u001a\u00020mH\u0002J\u000e\u0010\u0010\u001a\u00020^2\u0006\u0010\u000b\u001a\u00020\rJ\u000f\u0010\u008d\u0001\u001a\u00020^2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u001a\u001a\u00020^2\u0006\u0010\u0018\u001a\u00020\rJ\u000f\u0010\u008e\u0001\u001a\u00020^2\u0006\u0010\u001b\u001a\u00020\rJ,\u0010\u008f\u0001\u001a\u00020^2\u0006\u0010d\u001a\u00020%2\u0007\u0010\u008c\u0001\u001a\u00020m2\u0007\u0010\u0090\u0001\u001a\u00020L2\u0007\u0010\u0091\u0001\u001a\u00020\u0001H\u0002J\u0010\u0010\u0092\u0001\u001a\u00020^2\u0007\u0010\u0093\u0001\u001a\u00020\rJ\u0010\u0010\u0094\u0001\u001a\u00020^2\u0007\u0010\u0093\u0001\u001a\u00020LJ\u0010\u0010\u0095\u0001\u001a\u00020^2\u0007\u0010\u0096\u0001\u001a\u00020\rJ\u0010\u0010\u0097\u0001\u001a\u00020^2\u0007\u0010\u0096\u0001\u001a\u00020LJ\u000f\u0010\u0098\u0001\u001a\u00020^2\u0006\u00105\u001a\u00020\rJ\u000f\u0010\u0099\u0001\u001a\u00020^2\u0006\u00107\u001a\u00020\rJ\u000f\u0010\u009a\u0001\u001a\u00020^2\u0006\u00108\u001a\u00020\rJ\u000f\u0010\u009b\u0001\u001a\u00020^2\u0006\u0010:\u001a\u00020\rJ\u000f\u0010\u009c\u0001\u001a\u00020^2\u0006\u0010:\u001a\u00020LJ\u000e\u0010>\u001a\u00020^2\u0006\u0010<\u001a\u00020\rJ\u0017\u0010\u009d\u0001\u001a\u00020^2\u0006\u0010d\u001a\u00020%2\u0006\u0010a\u001a\u00020yJ\u0010\u0010\u009e\u0001\u001a\u00020^2\u0007\u0010\u009f\u0001\u001a\u00020\rJ\u0010\u0010\u009e\u0001\u001a\u00020^2\u0007\u0010\u009f\u0001\u001a\u00020LJ\u0015\u0010\u009e\u0001\u001a\u00020^2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0015\u0010\u00a0\u0001\u001a\u00020^2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020L0\fJ\u0010\u0010\u00a1\u0001\u001a\u00020^2\u0007\u0010\u00a2\u0001\u001a\u00020\rJ\u0010\u0010\u00a1\u0001\u001a\u00020^2\u0007\u0010\u00a2\u0001\u001a\u00020LJ\u0015\u0010\u00a1\u0001\u001a\u00020^2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0015\u0010\u00a3\u0001\u001a\u00020^2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020L0\fJ\u0010\u0010\u00a4\u0001\u001a\u00020^2\u0007\u0010\u00a5\u0001\u001a\u00020\rJ\u0010\u0010\u00a4\u0001\u001a\u00020^2\u0007\u0010\u00a5\u0001\u001a\u00020LJ\u0015\u0010\u00a4\u0001\u001a\u00020^2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0015\u0010\u00a6\u0001\u001a\u00020^2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020L0\fJ\u000f\u0010\u00a7\u0001\u001a\u00020^2\u0006\u0010I\u001a\u00020\rJ\u000f\u0010\u00a8\u0001\u001a\u00020^2\u0006\u0010I\u001a\u00020LJ\u000f\u0010N\u001a\u00020^2\u0007\u0010\u00a9\u0001\u001a\u00020LJ\u000f\u0010\u00aa\u0001\u001a\u00020^2\u0006\u0010O\u001a\u00020\rJ\u000f\u0010\u00ab\u0001\u001a\u00020^2\u0006\u0010O\u001a\u00020LJ\u0017\u0010\u00ac\u0001\u001a\u00020^2\u0006\u0010d\u001a\u00020%2\u0006\u0010a\u001a\u00020\rJ\u001d\u0010\u00ad\u0001\u001a\u00020^2\u0006\u0010d\u001a\u00020%2\f\u0010a\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0017\u0010\u00ae\u0001\u001a\u00020^2\u0006\u0010d\u001a\u00020%2\u0006\u0010a\u001a\u00020LJ\u001d\u0010\u00af\u0001\u001a\u00020^2\u0006\u0010d\u001a\u00020%2\f\u0010a\u001a\b\u0012\u0004\u0012\u00020L0\fJ\u000e\u0010Y\u001a\u00020^2\u0006\u0010W\u001a\u00020LJ\u000e\u0010\\\u001a\u00020^2\u0006\u0010Z\u001a\u00020LJ\u0007\u0010\u00b0\u0001\u001a\u00020LJ\u0007\u0010\u00b1\u0001\u001a\u00020LJ,\u0010\u00b2\u0001\u001a\u00020\r2\u000f\u0010\u0091\u0001\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0007\u0010\u00b3\u0001\u001a\u00020\r2\u0007\u0010\u00b4\u0001\u001a\u00020\rH\u0002R4\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R4\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u000f\"\u0004\b\u001a\u0010\u0011R\u0013\u0010\u001b\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\"\u0010 \u001a\u0004\u0018\u00010\u001f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001e\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010#\u001a\u001e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u00040$j\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u0004`&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010'\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010*R\u0011\u0010-\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0010\u0010/\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u00101\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u001dR\u0013\u00103\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u001dR\u0013\u00105\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u001dR\u000e\u00107\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u00108\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u001dR\u0013\u0010:\u001a\u0004\u0018\u00010(8F\u00a2\u0006\u0006\u001a\u0004\b;\u0010*R4\u0010<\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u000e\u0010<\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b=\u0010\u000f\"\u0004\b>\u0010\u0011R$\u0010?\u001a\u00020\r2\u0006\u0010?\u001a\u00020\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b@\u0010\u0014\"\u0004\bA\u0010BR\u0019\u0010C\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\bD\u0010\u000fR\u0019\u0010E\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\bF\u0010\u000fR\u0019\u0010G\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\bH\u0010\u000fR\u0013\u0010I\u001a\u0004\u0018\u00010(8F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010*R4\u0010K\u001a\n\u0012\u0004\u0012\u00020L\u0018\u00010\f2\u000e\u0010K\u001a\n\u0012\u0004\u0012\u00020L\u0018\u00010\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bM\u0010\u000f\"\u0004\bN\u0010\u0011R\u0013\u0010O\u001a\u0004\u0018\u00010(8F\u00a2\u0006\u0006\u001a\u0004\bP\u0010*R\u001c\u0010Q\u001a\u0004\u0018\u00010RX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010T\"\u0004\bU\u0010VR4\u0010W\u001a\n\u0012\u0004\u0012\u00020L\u0018\u00010\f2\u000e\u0010W\u001a\n\u0012\u0004\u0012\u00020L\u0018\u00010\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bX\u0010\u000f\"\u0004\bY\u0010\u0011R4\u0010Z\u001a\n\u0012\u0004\u0012\u00020L\u0018\u00010\f2\u000e\u0010Z\u001a\n\u0012\u0004\u0012\u00020L\u0018\u00010\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b[\u0010\u000f\"\u0004\b\\\u0010\u0011\u00a8\u0006\u00b5\u0001"}, d2={"Lag/granular/tiff/FileDirectory;", "", "entries", "Ljava/util/LinkedHashSet;", "Lag/granular/tiff/FileDirectoryEntry;", "Lkotlin/collections/LinkedHashSet;", "reader", "Lag/granular/tiff/io/ByteReader;", "cacheData", "", "(Ljava/util/LinkedHashSet;Lag/granular/tiff/io/ByteReader;Z)V", "bitsPerSample", "", "", "getBitsPerSample", "()Ljava/util/List;", "setBitsPerSample", "(Ljava/util/List;)V", "bytesPerPixel", "getBytesPerPixel", "()I", "cache", "", "", "colorMap", "getColorMap", "setColorMap", "compression", "getCompression", "()Ljava/lang/Integer;", "<set-?>", "Lag/granular/tiff/compression/CompressionDecoder;", "decoder", "getDecoder", "()Lag/granular/tiff/compression/CompressionDecoder;", "fieldTagTypeMapping", "Ljava/util/HashMap;", "Lag/granular/tiff/FieldTagType;", "Lkotlin/collections/HashMap;", "imageHeight", "", "getImageHeight", "()Ljava/lang/Number;", "imageWidth", "getImageWidth", "isTiled", "()Z", "lastBlock", "lastBlockIndex", "maxBitsPerSample", "getMaxBitsPerSample", "maxSampleFormat", "getMaxSampleFormat", "photometricInterpretation", "getPhotometricInterpretation", "planarConfiguration", "resolutionUnit", "getResolutionUnit", "rowsPerStrip", "getRowsPerStrip", "sampleFormat", "getSampleFormat", "setSampleFormat", "samplesPerPixel", "getSamplesPerPixel", "setSamplesPerPixel", "(I)V", "stripByteCounts", "getStripByteCounts", "stripOffsets", "getStripOffsets", "tileByteCounts", "getTileByteCounts", "tileHeight", "getTileHeight", "tileOffsets", "", "getTileOffsets", "setTileOffsets", "tileWidth", "getTileWidth", "writeRasters", "Lag/granular/tiff/Rasters;", "getWriteRasters", "()Lag/granular/tiff/Rasters;", "setWriteRasters", "(Lag/granular/tiff/Rasters;)V", "xResolution", "getXResolution", "setXResolution", "yResolution", "getYResolution", "setYResolution", "addEntry", "", "entry", "createSingleIntegerList", "value", "createSingleLongList", "get", "fieldTagType", "getEntries", "", "getEntryValue", "T", "(Lag/granular/tiff/FieldTagType;)Ljava/lang/Object;", "getFieldTagTypeMapping", "", "getFieldTypeForSample", "Lag/granular/tiff/FieldType;", "sampleIndex", "getIntegerEntryValue", "getIntegerListEntryValue", "getLongListEntryValue", "getMaxIntegerEntryValue", "(Lag/granular/tiff/FieldTagType;)Ljava/lang/Integer;", "getNumberEntryValue", "getNumberListEntryValue", "getPlanarConfiguration", "getSampleByteSize", "getStringEntryValue", "", "getTileOrStrip", "x", "y", "sample", "numEntries", "readInterleavedRasters", "window", "Lag/granular/tiff/ImageWindow;", "samples", "", "readRaster", "rasters", "readRasters", "sampleValues", "interleaveValues", "readTypedRasters", "Lag/granular/tiff/TypedRasters;", "readValue", "fieldType", "setCache", "setCompression", "setEntryValue", "typeCount", "values", "setImageHeight", "height", "setImageHeightAsLong", "setImageWidth", "width", "setImageWidthAsLong", "setPhotometricInterpretation", "setPlanarConfiguration", "setResolutionUnit", "setRowsPerStrip", "setRowsPerStripAsLong", "setStringEntryValue", "setStripByteCounts", "stripByteCount", "setStripByteCountsAsLongs", "setStripOffsets", "stripOffset", "setStripOffsetsAsLongs", "setTileByteCounts", "tileByteCount", "setTileByteCountsAsLongs", "setTileHeight", "setTileHeightAsLong", "tileOffset", "setTileWidth", "setTileWidthAsLong", "setUnsignedIntegerEntryValue", "setUnsignedIntegerListEntryValue", "setUnsignedLongEntryValue", "setUnsignedLongListEntryValue", "size", "sizeWithValues", "sum", "start", "end", "tiffany"})
public final class FileDirectory {
    private final HashMap<FieldTagType, FileDirectoryEntry> fieldTagTypeMapping;
    private final boolean isTiled;
    private final int planarConfiguration;
    @Nullable
    private CompressionDecoder decoder;
    private Map<Integer, byte[]> cache;
    @Nullable
    private Rasters writeRasters;
    private int lastBlockIndex;
    private byte[] lastBlock;
    private final LinkedHashSet<FileDirectoryEntry> entries;
    private final ByteReader reader;

    public final boolean isTiled() {
        return this.isTiled;
    }

    @Nullable
    public final CompressionDecoder getDecoder() {
        return this.decoder;
    }

    @Nullable
    public final Rasters getWriteRasters() {
        return this.writeRasters;
    }

    public final void setWriteRasters(@Nullable Rasters rasters) {
        this.writeRasters = rasters;
    }

    @NotNull
    public final Number getImageWidth() {
        Number number = this.getNumberEntryValue(FieldTagType.ImageWidth);
        Intrinsics.checkNotNull((Object)number);
        return number;
    }

    @NotNull
    public final Number getImageHeight() {
        Number number = this.getNumberEntryValue(FieldTagType.ImageLength);
        Intrinsics.checkNotNull((Object)number);
        return number;
    }

    @Nullable
    public final List<Integer> getBitsPerSample() {
        return this.getIntegerListEntryValue(FieldTagType.BitsPerSample);
    }

    public final void setBitsPerSample(@Nullable List<Integer> bitsPerSample) {
        List<Integer> list = bitsPerSample;
        Intrinsics.checkNotNull(list);
        this.setUnsignedIntegerListEntryValue(FieldTagType.BitsPerSample, list);
    }

    @Nullable
    public final Integer getMaxBitsPerSample() {
        return this.getMaxIntegerEntryValue(FieldTagType.BitsPerSample);
    }

    @Nullable
    public final Integer getCompression() {
        return this.getIntegerEntryValue(FieldTagType.Compression);
    }

    @Nullable
    public final Integer getPhotometricInterpretation() {
        return this.getIntegerEntryValue(FieldTagType.PhotometricInterpretation);
    }

    @Nullable
    public final List<Number> getStripOffsets() {
        return this.getNumberListEntryValue(FieldTagType.StripOffsets);
    }

    public final int getSamplesPerPixel() {
        int samplesPerPixel = this.getIntegerEntryValue(FieldTagType.SamplesPerPixel);
        return samplesPerPixel;
    }

    public final void setSamplesPerPixel(int samplesPerPixel) {
        this.setUnsignedIntegerEntryValue(FieldTagType.SamplesPerPixel, samplesPerPixel);
    }

    @Nullable
    public final Number getRowsPerStrip() {
        Number number;
        try {
            number = this.getNumberEntryValue(FieldTagType.RowsPerStrip);
        }
        catch (TiffException err) {
            number = null;
        }
        return number;
    }

    @Nullable
    public final List<Number> getStripByteCounts() {
        return this.getNumberListEntryValue(FieldTagType.StripByteCounts);
    }

    @Nullable
    public final List<Long> getXResolution() {
        return this.getLongListEntryValue(FieldTagType.XResolution);
    }

    public final void setXResolution(@Nullable List<Long> xResolution) {
        List<Long> list = xResolution;
        Intrinsics.checkNotNull(list);
        this.setUnsignedLongListEntryValue(FieldTagType.XResolution, list);
    }

    @Nullable
    public final List<Long> getYResolution() {
        return this.getLongListEntryValue(FieldTagType.YResolution);
    }

    public final void setYResolution(@Nullable List<Long> yResolution) {
        List<Long> list = yResolution;
        Intrinsics.checkNotNull(list);
        this.setUnsignedLongListEntryValue(FieldTagType.YResolution, list);
    }

    @Nullable
    public final Integer getResolutionUnit() {
        return this.getIntegerEntryValue(FieldTagType.ResolutionUnit);
    }

    @Nullable
    public final List<Integer> getColorMap() {
        return this.getIntegerListEntryValue(FieldTagType.ColorMap);
    }

    public final void setColorMap(@Nullable List<Integer> colorMap) {
        List<Integer> list = colorMap;
        Intrinsics.checkNotNull(list);
        this.setUnsignedIntegerListEntryValue(FieldTagType.ColorMap, list);
    }

    @Nullable
    public final Number getTileWidth() {
        return this.isTiled ? (Number)this.getNumberEntryValue(FieldTagType.TileWidth) : (Number)this.getImageWidth();
    }

    @Nullable
    public final Number getTileHeight() {
        return this.isTiled ? (Number)this.getNumberEntryValue(FieldTagType.TileLength) : (Number)this.getRowsPerStrip();
    }

    @Nullable
    public final List<Long> getTileOffsets() {
        return this.getLongListEntryValue(FieldTagType.TileOffsets);
    }

    public final void setTileOffsets(@Nullable List<Long> tileOffsets) {
        List<Long> list = tileOffsets;
        Intrinsics.checkNotNull(list);
        this.setUnsignedLongListEntryValue(FieldTagType.TileOffsets, list);
    }

    @Nullable
    public final List<Number> getTileByteCounts() {
        return this.getNumberListEntryValue(FieldTagType.TileByteCounts);
    }

    @Nullable
    public final List<Integer> getSampleFormat() {
        return this.getIntegerListEntryValue(FieldTagType.SampleFormat);
    }

    public final void setSampleFormat(@Nullable List<Integer> sampleFormat) {
        List<Integer> list = sampleFormat;
        Intrinsics.checkNotNull(list);
        this.setUnsignedIntegerListEntryValue(FieldTagType.SampleFormat, list);
    }

    @Nullable
    public final Integer getMaxSampleFormat() {
        return this.getMaxIntegerEntryValue(FieldTagType.SampleFormat);
    }

    /*
     * WARNING - void declaration
     */
    private final int getBytesPerPixel() {
        int bitsPerSample = 0;
        List<Integer> list = this.getBitsPerSample();
        Intrinsics.checkNotNull(list);
        List<Integer> bitsPerSamples = list;
        int n = 0;
        int n2 = ((Collection)bitsPerSamples).size();
        while (n < n2) {
            void i;
            int bits = ((Number)bitsPerSamples.get((int)i)).intValue();
            if (bits % 8 != 0) {
                throw (Throwable)new TiffException("Sample bit-width of " + bits + " is not supported");
            }
            if (bits != ((Number)bitsPerSamples.get(0)).intValue()) {
                throw (Throwable)new TiffException("Differing size of samples in a pixel are not supported. sample 0 = " + ((Number)bitsPerSamples.get(0)).intValue() + ", sample " + (int)i + " = " + bits);
            }
            bitsPerSample += bits;
            ++i;
        }
        return bitsPerSample / 8;
    }

    public final void addEntry(@NotNull FileDirectoryEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.entries.remove(entry);
        this.entries.add(entry);
        ((Map)this.fieldTagTypeMapping).put(entry.getFieldTag(), entry);
    }

    public final void setCache(boolean cacheData) {
        if (cacheData) {
            if (this.cache == null) {
                this.cache = new HashMap();
            }
        } else {
            this.cache = null;
        }
    }

    public final int numEntries() {
        return this.entries.size();
    }

    @NotNull
    public final FileDirectoryEntry get(@NotNull FieldTagType fieldTagType) {
        Intrinsics.checkNotNullParameter((Object)((Object)fieldTagType), (String)"fieldTagType");
        FileDirectoryEntry fileDirectoryEntry = this.fieldTagTypeMapping.get((Object)fieldTagType);
        Intrinsics.checkNotNull((Object)fileDirectoryEntry);
        return fileDirectoryEntry;
    }

    @NotNull
    public final Set<FileDirectoryEntry> getEntries() {
        return CollectionsKt.toSet((Iterable)this.entries);
    }

    @NotNull
    public final Map<FieldTagType, FileDirectoryEntry> getFieldTagTypeMapping() {
        return MapsKt.toMap((Map)this.fieldTagTypeMapping);
    }

    public final void setImageWidth(int width) {
        this.setUnsignedIntegerEntryValue(FieldTagType.ImageWidth, width);
    }

    public final void setImageWidthAsLong(long width) {
        this.setUnsignedLongEntryValue(FieldTagType.ImageWidth, width);
    }

    public final void setImageHeight(int height) {
        this.setUnsignedIntegerEntryValue(FieldTagType.ImageLength, height);
    }

    public final void setImageHeightAsLong(long height) {
        this.setUnsignedLongEntryValue(FieldTagType.ImageLength, height);
    }

    public final void setBitsPerSample(int bitsPerSample) {
        this.setBitsPerSample(this.createSingleIntegerList(bitsPerSample));
    }

    public final void setCompression(int compression) {
        this.setUnsignedIntegerEntryValue(FieldTagType.Compression, compression);
    }

    public final void setPhotometricInterpretation(int photometricInterpretation) {
        this.setUnsignedIntegerEntryValue(FieldTagType.PhotometricInterpretation, photometricInterpretation);
    }

    public final void setStripOffsets(@NotNull List<Integer> stripOffsets) {
        Intrinsics.checkNotNullParameter(stripOffsets, (String)"stripOffsets");
        this.setUnsignedIntegerListEntryValue(FieldTagType.StripOffsets, stripOffsets);
    }

    public final void setStripOffsetsAsLongs(@NotNull List<Long> stripOffsets) {
        Intrinsics.checkNotNullParameter(stripOffsets, (String)"stripOffsets");
        this.setUnsignedLongListEntryValue(FieldTagType.StripOffsets, stripOffsets);
    }

    public final void setStripOffsets(int stripOffset) {
        this.setStripOffsets(this.createSingleIntegerList(stripOffset));
    }

    public final void setStripOffsets(long stripOffset) {
        this.setStripOffsetsAsLongs(this.createSingleLongList(stripOffset));
    }

    public final void setRowsPerStrip(int rowsPerStrip) {
        this.setUnsignedIntegerEntryValue(FieldTagType.RowsPerStrip, rowsPerStrip);
    }

    public final void setRowsPerStripAsLong(long rowsPerStrip) {
        this.setUnsignedLongEntryValue(FieldTagType.RowsPerStrip, rowsPerStrip);
    }

    public final void setStripByteCounts(@NotNull List<Integer> stripByteCounts) {
        Intrinsics.checkNotNullParameter(stripByteCounts, (String)"stripByteCounts");
        this.setUnsignedIntegerListEntryValue(FieldTagType.StripByteCounts, stripByteCounts);
    }

    public final void setStripByteCountsAsLongs(@NotNull List<Long> stripByteCounts) {
        Intrinsics.checkNotNullParameter(stripByteCounts, (String)"stripByteCounts");
        this.setUnsignedLongListEntryValue(FieldTagType.StripByteCounts, stripByteCounts);
    }

    public final void setStripByteCounts(int stripByteCount) {
        this.setStripByteCounts(this.createSingleIntegerList(stripByteCount));
    }

    public final void setStripByteCounts(long stripByteCount) {
        this.setStripByteCountsAsLongs(this.createSingleLongList(stripByteCount));
    }

    public final void setXResolution(long xResolution) {
        this.setXResolution(this.createSingleLongList(xResolution));
    }

    public final void setYResolution(long yResolution) {
        this.setYResolution(this.createSingleLongList(yResolution));
    }

    @Nullable
    public final Integer getPlanarConfiguration() {
        return this.getIntegerEntryValue(FieldTagType.PlanarConfiguration);
    }

    public final void setPlanarConfiguration(int planarConfiguration) {
        this.setUnsignedIntegerEntryValue(FieldTagType.PlanarConfiguration, planarConfiguration);
    }

    public final void setResolutionUnit(int resolutionUnit) {
        this.setUnsignedIntegerEntryValue(FieldTagType.ResolutionUnit, resolutionUnit);
    }

    public final void setColorMap(int colorMap) {
        this.setColorMap(this.createSingleIntegerList(colorMap));
    }

    public final void setTileWidth(int tileWidth) {
        this.setUnsignedIntegerEntryValue(FieldTagType.TileWidth, tileWidth);
    }

    public final void setTileWidthAsLong(long tileWidth) {
        this.setUnsignedLongEntryValue(FieldTagType.TileWidth, tileWidth);
    }

    public final void setTileHeight(int tileHeight) {
        this.setUnsignedIntegerEntryValue(FieldTagType.TileLength, tileHeight);
    }

    public final void setTileHeightAsLong(long tileHeight) {
        this.setUnsignedLongEntryValue(FieldTagType.TileLength, tileHeight);
    }

    public final void setTileOffsets(long tileOffset) {
        this.setTileOffsets(this.createSingleLongList(tileOffset));
    }

    public final void setTileByteCounts(@NotNull List<Integer> tileByteCounts) {
        Intrinsics.checkNotNullParameter(tileByteCounts, (String)"tileByteCounts");
        this.setUnsignedIntegerListEntryValue(FieldTagType.TileByteCounts, tileByteCounts);
    }

    public final void setTileByteCountsAsLongs(@NotNull List<Long> tileByteCounts) {
        Intrinsics.checkNotNullParameter(tileByteCounts, (String)"tileByteCounts");
        this.setUnsignedLongListEntryValue(FieldTagType.TileByteCounts, tileByteCounts);
    }

    public final void setTileByteCounts(int tileByteCount) {
        this.setTileByteCounts(this.createSingleIntegerList(tileByteCount));
    }

    public final void setTileByteCounts(long tileByteCount) {
        this.setTileByteCountsAsLongs(this.createSingleLongList(tileByteCount));
    }

    public final void setSampleFormat(int sampleFormat) {
        this.setSampleFormat(this.createSingleIntegerList(sampleFormat));
    }

    @NotNull
    public final Rasters readRasters() {
        return FileDirectory.readRasters$default(this, FileDirectoryKt.getWindow(this), null, false, false, 14, null);
    }

    @NotNull
    public final Rasters readInterleavedRasters() {
        return FileDirectory.readInterleavedRasters$default(this, FileDirectoryKt.getWindow(this), null, 2, null);
    }

    @NotNull
    public final Rasters readRasters(@NotNull int[] samples) {
        Intrinsics.checkNotNullParameter((Object)samples, (String)"samples");
        return FileDirectory.readRasters$default(this, FileDirectoryKt.getWindow(this), samples, false, false, 12, null);
    }

    @NotNull
    public final Rasters readInterleavedRasters(@NotNull int[] samples) {
        Intrinsics.checkNotNullParameter((Object)samples, (String)"samples");
        return this.readInterleavedRasters(FileDirectoryKt.getWindow(this), samples);
    }

    @NotNull
    public final Rasters readInterleavedRasters(@NotNull ImageWindow window, @Nullable int[] samples) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        return this.readRasters(window, samples, false, true);
    }

    public static /* synthetic */ Rasters readInterleavedRasters$default(FileDirectory fileDirectory, ImageWindow imageWindow, int[] nArray, int n, Object object) {
        if ((n & 2) != 0) {
            nArray = null;
        }
        return fileDirectory.readInterleavedRasters(imageWindow, nArray);
    }

    @NotNull
    public final Rasters readRasters(boolean sampleValues, boolean interleaveValues) {
        return this.readRasters(FileDirectoryKt.getWindow(this), sampleValues, interleaveValues);
    }

    @NotNull
    public final Rasters readRasters(@NotNull ImageWindow window, boolean sampleValues, boolean interleaveValues) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        return this.readRasters(window, null, sampleValues, interleaveValues);
    }

    @NotNull
    public final Rasters readRasters(@NotNull int[] samples, boolean sampleValues, boolean interleaveValues) {
        Intrinsics.checkNotNullParameter((Object)samples, (String)"samples");
        return this.readRasters(FileDirectoryKt.getWindow(this), samples, sampleValues, interleaveValues);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Rasters readRasters(@NotNull ImageWindow window, @Nullable int[] samples, boolean sampleValues, boolean interleaveValues) {
        Object object;
        Object[] objectArray;
        int n;
        int n2;
        int i;
        int n3;
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        int[] samples2 = samples;
        Number number = this.getImageWidth();
        Intrinsics.checkNotNull((Object)number);
        int width = number.intValue();
        Number number2 = this.getImageHeight();
        Intrinsics.checkNotNull((Object)number2);
        int height = number2.intValue();
        if (window.getMinX() < 0 || window.getMinY() < 0 || window.getMaxX() > width || window.getMaxY() > height) {
            throw (Throwable)new TiffException("Window is out of the image bounds. Width: " + width + ", Height: " + height + ", Window: " + window);
        }
        if (window.getMinX() > window.getMaxX() || window.getMinY() > window.getMaxY()) {
            throw (Throwable)new TiffException("Invalid window range: " + window);
        }
        int windowWidth = window.getMaxX() - window.getMinX();
        int windowHeight = window.getMaxY() - window.getMinY();
        int numPixels = windowWidth * windowHeight;
        int samplesPerPixel = this.getSamplesPerPixel();
        if (samples2 == null) {
            samples2 = new int[samplesPerPixel];
            int n4 = 0;
            n3 = samples2.length;
            while (n4 < n3) {
                samples2[i] = i;
                ++i;
            }
        } else {
            n3 = samples2.length;
            for (i = 0; i < n3; ++i) {
                if (samples2[i] < samplesPerPixel) continue;
                throw (Throwable)new TiffException("Invalid sample index: " + samples2[i]);
            }
        }
        List<Integer> bitsPerSample = this.getBitsPerSample();
        int bytesPerPixel = 0;
        int n5 = 0;
        int n6 = samplesPerPixel;
        while (n5 < n6) {
            void i2;
            List<Integer> list = bitsPerSample;
            Intrinsics.checkNotNull(list);
            bytesPerPixel += ((Number)list.get((int)i2)).intValue() / 8;
            ++i2;
        }
        ByteBuffer interleave = null;
        if (interleaveValues) {
            ByteBuffer byteBuffer = ByteBuffer.Companion.allocate(numPixels * bytesPerPixel);
            boolean bl = false;
            n2 = 0;
            ByteBuffer $this$apply = byteBuffer;
            boolean bl2 = false;
            $this$apply.order(this.reader.getByteReaderOrder());
            interleave = byteBuffer;
        }
        ByteBuffer[] sample = null;
        if (sampleValues) {
            ByteBuffer[] byteBufferArray = new ByteBuffer[samplesPerPixel];
            n2 = 0;
            while (n2 < samplesPerPixel) {
                void i3;
                int $this$apply = n2;
                n = n2++;
                objectArray = byteBufferArray;
                boolean bl = false;
                List<Integer> list = bitsPerSample;
                Intrinsics.checkNotNull(list);
                ByteBuffer byteBuffer = ByteBuffer.Companion.allocate(numPixels * ((Number)list.get((int)i3)).intValue() / 8);
                boolean bl3 = false;
                boolean bl4 = false;
                ByteBuffer $this$apply2 = byteBuffer;
                boolean bl5 = false;
                $this$apply2.order(this.reader.getByteReaderOrder());
                object = byteBuffer;
                objectArray[n] = object;
            }
            sample = byteBufferArray;
        }
        n2 = samples2.length;
        FieldType[] fieldTypeArray = new FieldType[n2];
        int n7 = 0;
        while (n7 < n2) {
            void i4;
            int n8 = n7;
            n = n7++;
            objectArray = fieldTypeArray;
            boolean bl = false;
            object = this.getFieldTypeForSample(samples2[i4]);
            objectArray[n] = object;
        }
        FieldType[] fieldTypes = fieldTypeArray;
        Rasters rasters = new Rasters(windowWidth, windowHeight, fieldTypes, sample, interleave);
        this.readRaster(window, samples2, rasters);
        return rasters;
    }

    public static /* synthetic */ Rasters readRasters$default(FileDirectory fileDirectory, ImageWindow imageWindow, int[] nArray, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            nArray = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return fileDirectory.readRasters(imageWindow, nArray, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    private final void readRaster(ImageWindow window, int[] samples, Rasters rasters) {
        int i;
        int n;
        Object[] objectArray;
        int n2;
        Number number = this.getTileWidth();
        Intrinsics.checkNotNull((Object)number);
        int tileWidth = number.intValue();
        Number number2 = this.getTileHeight();
        Intrinsics.checkNotNull((Object)number2);
        int tileHeight = number2.intValue();
        int minXTile = window.getMinX() / tileWidth;
        int maxXTile = (window.getMaxX() + tileWidth - 1) / tileWidth;
        int minYTile = window.getMinY() / tileHeight;
        int maxYTile = (window.getMaxY() + tileHeight - 1) / tileHeight;
        int windowWidth = window.getMaxX() - window.getMinX();
        int bytesPerPixel = this.getBytesPerPixel();
        int n3 = samples.length;
        int[] nArray = new int[n3];
        for (int j = 0; j < n3; ++j) {
            int n4;
            int n5 = j;
            n2 = j;
            objectArray = nArray;
            n = 0;
            int sampleOffset = 0;
            if (this.planarConfiguration == 1) {
                sampleOffset = this.sum(this.getBitsPerSample(), 0, samples[i]) / 8;
            }
            objectArray[n2] = n4 = sampleOffset;
        }
        int[] srcSampleOffsets = nArray;
        int n6 = samples.length;
        FieldType[] fieldTypeArray = new FieldType[n6];
        i = 0;
        while (i < n6) {
            void i2;
            n = i;
            n2 = i++;
            objectArray = (Object[])fieldTypeArray;
            boolean bl = false;
            FieldType fieldType = this.getFieldTypeForSample(samples[i2]);
            objectArray[n2] = (int)fieldType;
        }
        FieldType[] sampleFieldTypes = fieldTypeArray;
        n6 = minYTile;
        int n7 = maxYTile;
        while (n6 < n7) {
            void yTile;
            i = minXTile;
            int n8 = maxXTile;
            while (i < n8) {
                void xTile;
                void firstLine = yTile * tileHeight;
                void firstCol = xTile * tileWidth;
                void lastLine = (yTile + true) * tileHeight;
                void lastCol = (xTile + true) * tileWidth;
                int n9 = 0;
                int n10 = samples.length;
                while (n9 < n10) {
                    void sampleIndex;
                    int sample = samples[sampleIndex];
                    if (this.planarConfiguration == 2) {
                        bytesPerPixel = this.getSampleByteSize(sample);
                    }
                    byte[] block = this.getTileOrStrip((int)xTile, (int)yTile, sample);
                    ByteReader blockReader = new ByteReader(block, this.reader.getByteReaderOrder());
                    int n11 = 0;
                    int n12 = window.getMinY() - firstLine;
                    int n13 = 0;
                    int n14 = Math.max(n11, n12);
                    n11 = tileHeight - (lastLine - window.getMaxY());
                    n12 = 0;
                    int n15 = Math.min(tileHeight, n11);
                    while (n14 < n15) {
                        void y;
                        n13 = 0;
                        int n16 = window.getMinX() - firstCol;
                        boolean bl = false;
                        n11 = Math.max(n13, n16);
                        n13 = tileWidth - (lastCol - window.getMaxX());
                        n16 = 0;
                        n12 = Math.min(tileWidth, n13);
                        while (n11 < n12) {
                            void windowCoordinate;
                            void x;
                            void pixelOffset = (y * tileWidth + x) * bytesPerPixel;
                            void valueOffset = pixelOffset + srcSampleOffsets[sampleIndex];
                            blockReader.setNextByte((int)valueOffset);
                            FieldType fieldType = sampleFieldTypes[sampleIndex];
                            Intrinsics.checkNotNull((Object)((Object)fieldType));
                            Number value = this.readValue(blockReader, fieldType);
                            if (rasters.hasInterleaveValues()) {
                                windowCoordinate = (y + firstLine - window.getMinY()) * windowWidth + (x + firstCol - window.getMinX());
                                rasters.addToInterleave((int)sampleIndex, (int)windowCoordinate, value);
                            }
                            if (rasters.hasSampleValues()) {
                                windowCoordinate = (y + firstLine - window.getMinY()) * windowWidth + x + firstCol - window.getMinX();
                                rasters.addToSample((int)sampleIndex, (int)windowCoordinate, value);
                            }
                            ++x;
                        }
                        ++y;
                    }
                    ++sampleIndex;
                }
                ++xTile;
            }
            ++yTile;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TypedRasters readTypedRasters() {
        int i;
        int n;
        int $i$a$-List-FileDirectory$readTypedRasters$samples$222;
        Object[] objectArray;
        ImageWindow window = FileDirectoryKt.getWindow(this);
        int width = this.getImageWidth().intValue();
        int height = this.getImageHeight().intValue();
        if (window.getMinX() < 0 || window.getMinY() < 0 || window.getMaxX() > width || window.getMaxY() > height) {
            throw (Throwable)new TiffException("Window is out of the image bounds. Width: " + width + ", Height: " + height + ", Window: " + window);
        }
        if (window.getMinX() > window.getMaxX() || window.getMinY() > window.getMaxY()) {
            throw (Throwable)new TiffException("Invalid window range: " + window);
        }
        int windowWidth = window.getMaxX() - window.getMinX();
        int windowHeight = window.getMaxY() - window.getMinY();
        int numPixels = windowWidth * windowHeight;
        int samplesPerPixel = this.getSamplesPerPixel();
        List<Integer> bitsPerSample = this.getBitsPerSample();
        int bytesPerPixel = 0;
        int n2 = 0;
        int n3 = samplesPerPixel;
        while (n2 < n3) {
            void i2;
            List<Integer> list = bitsPerSample;
            Intrinsics.checkNotNull(list);
            bytesPerPixel += ((Number)list.get((int)i2)).intValue() / 8;
            ++i2;
        }
        n3 = 0;
        boolean bl = false;
        FieldType[] fieldTypeArray = new ArrayList(samplesPerPixel);
        int n4 = 0;
        int n5 = 0;
        int n6 = samplesPerPixel;
        for (n5 = 0; n5 < n6; ++n5) {
            TypedSample typedSample;
            void it;
            int n7 = n5;
            boolean bl2 = false;
            int n8 = n7;
            objectArray = fieldTypeArray;
            $i$a$-List-FileDirectory$readTypedRasters$samples$222 = 0;
            FieldType fieldType = this.getFieldTypeForSample((int)it);
            switch (FileDirectory$WhenMappings.$EnumSwitchMapping$0[fieldType.ordinal()]) {
                case 1: {
                    void fieldType2;
                    typedSample = new TypedSample.ByteSample((FieldType)fieldType2, new byte[numPixels]);
                    break;
                }
                case 2: {
                    void fieldType2;
                    typedSample = new TypedSample.ShortSample((FieldType)fieldType2, new short[numPixels]);
                    break;
                }
                case 3: {
                    void fieldType2;
                    typedSample = new TypedSample.IntSample((FieldType)fieldType2, new int[numPixels]);
                    break;
                }
                case 4: {
                    void fieldType2;
                    typedSample = new TypedSample.ByteSample((FieldType)fieldType2, new byte[numPixels]);
                    break;
                }
                case 5: {
                    void fieldType2;
                    typedSample = new TypedSample.ShortSample((FieldType)fieldType2, new short[numPixels]);
                    break;
                }
                case 6: {
                    void fieldType2;
                    typedSample = new TypedSample.IntSample((FieldType)fieldType2, new int[numPixels]);
                    break;
                }
                case 7: {
                    void fieldType2;
                    typedSample = new TypedSample.FloatSample((FieldType)fieldType2, new float[numPixels]);
                    break;
                }
                case 8: {
                    void fieldType2;
                    typedSample = new TypedSample.DoubleSample((FieldType)fieldType2, new double[numPixels]);
                    break;
                }
                default: {
                    void fieldType2;
                    throw (Throwable)new TiffException("Unsupported raster field type: " + fieldType2);
                }
            }
            TypedSample typedSample2 = typedSample;
            objectArray.add(typedSample2);
        }
        List samples = (List)fieldTypeArray;
        FieldType[] fieldTypeArray2 = new FieldType[samplesPerPixel];
        int n9 = 0;
        while (n9 < samplesPerPixel) {
            void i3;
            FieldType fieldType;
            n4 = n9;
            int n10 = n9++;
            objectArray = fieldTypeArray2;
            boolean bl3 = false;
            objectArray[n10] = fieldType = this.getFieldTypeForSample((int)i3);
        }
        FieldType[] fieldTypes = fieldTypeArray2;
        Number number = this.getTileWidth();
        Intrinsics.checkNotNull((Object)number);
        int tileWidth = number.intValue();
        Number number2 = this.getTileHeight();
        Intrinsics.checkNotNull((Object)number2);
        int tileHeight = number2.intValue();
        int minXTile = window.getMinX() / tileWidth;
        int maxXTile = (window.getMaxX() + tileWidth - 1) / tileWidth;
        int minYTile = window.getMinY() / tileHeight;
        int maxYTile = (window.getMaxY() + tileHeight - 1) / tileHeight;
        int[] it = new int[samplesPerPixel];
        for ($i$a$-List-FileDirectory$readTypedRasters$samples$222 = 0; $i$a$-List-FileDirectory$readTypedRasters$samples$222 < samplesPerPixel; ++$i$a$-List-FileDirectory$readTypedRasters$samples$222) {
            int fieldType2 = $i$a$-List-FileDirectory$readTypedRasters$samples$222;
            int n11 = $i$a$-List-FileDirectory$readTypedRasters$samples$222;
            objectArray = it;
            n = 0;
            int sampleOffset = 0;
            if (this.planarConfiguration == 1) {
                void i4;
                sampleOffset = this.sum(bitsPerSample, 0, (int)i4) / 8;
            }
            int n12 = sampleOffset;
            objectArray[n11] = (FieldType)n12;
        }
        int[] srcSampleOffsets = it;
        FieldType[] $i$a$-List-FileDirectory$readTypedRasters$samples$222 = new FieldType[samplesPerPixel];
        int n13 = 0;
        while (n13 < samplesPerPixel) {
            FieldType fieldType;
            n = n13;
            int n14 = n13++;
            objectArray = $i$a$-List-FileDirectory$readTypedRasters$samples$222;
            boolean bl4 = false;
            objectArray[n14] = fieldType = this.getFieldTypeForSample(i);
        }
        FieldType[] sampleFieldTypes = $i$a$-List-FileDirectory$readTypedRasters$samples$222;
        int $i$a$-List-FileDirectory$readTypedRasters$samples$222 = minYTile;
        n13 = maxYTile;
        while ($i$a$-List-FileDirectory$readTypedRasters$samples$222 < n13) {
            void yTile;
            i = minXTile;
            int n15 = maxXTile;
            while (i < n15) {
                void xTile;
                void firstLine = yTile * tileHeight;
                void firstCol = xTile * tileWidth;
                void lastLine = (yTile + true) * tileHeight;
                void lastCol = (xTile + true) * tileWidth;
                int n16 = 0;
                int n17 = samplesPerPixel;
                while (n16 < n17) {
                    void sampleIndex;
                    if (this.planarConfiguration == 2) {
                        bytesPerPixel = this.getSampleByteSize((int)sampleIndex);
                    }
                    byte[] block = this.getTileOrStrip((int)xTile, (int)yTile, (int)sampleIndex);
                    ByteReader blockReader = new ByteReader(block, this.reader.getByteReaderOrder());
                    int n18 = 0;
                    int n19 = window.getMinY() - firstLine;
                    int n20 = 0;
                    int n21 = Math.max(n18, n19);
                    n18 = tileHeight - (lastLine - window.getMaxY());
                    n19 = 0;
                    int n22 = Math.min(tileHeight, n18);
                    while (n21 < n22) {
                        void y;
                        n20 = 0;
                        int n23 = window.getMinX() - firstCol;
                        boolean bl5 = false;
                        n18 = Math.max(n20, n23);
                        n20 = tileWidth - (lastCol - window.getMaxX());
                        n23 = 0;
                        n19 = Math.min(tileWidth, n20);
                        while (n18 < n19) {
                            Unit unit;
                            void x;
                            void pixelOffset = (y * tileWidth + x) * bytesPerPixel;
                            void valueOffset = pixelOffset + srcSampleOffsets[sampleIndex];
                            blockReader.setNextByte((int)valueOffset);
                            Number value = this.readValue(blockReader, sampleFieldTypes[sampleIndex]);
                            void windowCoordinate = (y + firstLine - window.getMinY()) * windowWidth + x + firstCol - window.getMinX();
                            TypedSample typedSample = (TypedSample)samples.get((int)sampleIndex);
                            if (typedSample instanceof TypedSample.ByteSample) {
                                ((TypedSample.ByteSample)typedSample).getData()[windowCoordinate] = value.byteValue();
                                unit = Unit.INSTANCE;
                            } else if (typedSample instanceof TypedSample.ShortSample) {
                                ((TypedSample.ShortSample)typedSample).getData()[windowCoordinate] = value.shortValue();
                                unit = Unit.INSTANCE;
                            } else if (typedSample instanceof TypedSample.IntSample) {
                                ((TypedSample.IntSample)typedSample).getData()[windowCoordinate] = value.intValue();
                                unit = Unit.INSTANCE;
                            } else if (typedSample instanceof TypedSample.FloatSample) {
                                ((TypedSample.FloatSample)typedSample).getData()[windowCoordinate] = value.floatValue();
                                unit = Unit.INSTANCE;
                            } else if (typedSample instanceof TypedSample.DoubleSample) {
                                ((TypedSample.DoubleSample)typedSample).getData()[windowCoordinate] = value.doubleValue();
                                unit = Unit.INSTANCE;
                            } else {
                                throw new NoWhenBranchMatchedException();
                            }
                            Unit unit2 = unit;
                            ++x;
                        }
                        ++y;
                    }
                    ++sampleIndex;
                }
                ++xTile;
            }
            ++yTile;
        }
        return new TypedRasters(windowWidth, windowHeight, samples);
    }

    private final Number readValue(ByteReader reader, FieldType fieldType) {
        Number number;
        switch (FileDirectory$WhenMappings.$EnumSwitchMapping$1[fieldType.ordinal()]) {
            case 1: {
                number = reader.readUnsignedByte();
                break;
            }
            case 2: {
                number = reader.readUnsignedShort();
                break;
            }
            case 3: {
                number = reader.readUnsignedInt();
                break;
            }
            case 4: {
                number = reader.readByte();
                break;
            }
            case 5: {
                number = reader.readShort();
                break;
            }
            case 6: {
                number = reader.readInt();
                break;
            }
            case 7: {
                number = Float.valueOf(reader.readFloat());
                break;
            }
            case 8: {
                number = reader.readDouble();
                break;
            }
            default: {
                throw (Throwable)new TiffException("Unsupported raster field type: " + (Object)((Object)fieldType));
            }
        }
        return number;
    }

    @NotNull
    public final FieldType getFieldTypeForSample(int sampleIndex) {
        List<Integer> sampleFormatList = this.getSampleFormat();
        int sampleFormat = sampleFormatList == null ? 1 : ((Number)sampleFormatList.get(sampleIndex < sampleFormatList.size() ? sampleIndex : 0)).intValue();
        List<Integer> list = this.getBitsPerSample();
        Intrinsics.checkNotNull(list);
        int bitsPerSample = ((Number)list.get(sampleIndex)).intValue();
        return FieldType.Companion.getFieldType(sampleFormat, bitsPerSample);
    }

    /*
     * Unable to fully structure code
     */
    private final byte[] getTileOrStrip(int x, int y, int sample) {
        tileOrStrip = null;
        v0 = this.getImageWidth();
        Intrinsics.checkNotNull((Object)v0);
        imageWidth = v0.intValue();
        v1 = this.getImageHeight();
        Intrinsics.checkNotNull((Object)v1);
        imageHeight = v1.intValue();
        v2 = this.getTileWidth();
        Intrinsics.checkNotNull((Object)v2);
        tileWidth = v2.intValue();
        v3 = this.getTileHeight();
        Intrinsics.checkNotNull((Object)v3);
        tileHeight = v3.intValue();
        numTilesPerRow = (imageWidth + tileWidth - 1) / tileWidth;
        numTilesPerCol = (imageHeight + tileHeight - 1) / tileHeight;
        switch (this.planarConfiguration) {
            case 1: {
                v4 = y * numTilesPerRow + x;
                break;
            }
            case 2: {
                v4 = sample * numTilesPerRow * numTilesPerCol + y * numTilesPerRow + x;
                break;
            }
            default: {
                v4 = index = 0;
            }
        }
        if (this.cache == null) ** GOTO lbl-1000
        v5 = this.cache;
        Intrinsics.checkNotNull(v5);
        if (v5.containsKey(index)) {
            v6 = this.cache;
            Intrinsics.checkNotNull(v6);
            tileOrStrip = v6.get(index);
        } else if (this.lastBlockIndex == index && this.lastBlock != null) {
            tileOrStrip = this.lastBlock;
        } else {
            offset = 0;
            byteCount = 0;
            if (this.isTiled) {
                v7 = this.getTileOffsets();
                Intrinsics.checkNotNull(v7);
                offset = (int)((Number)v7.get(index)).longValue();
                v8 = this.getTileByteCounts();
                Intrinsics.checkNotNull(v8);
                byteCount = v8.get(index).intValue();
            } else {
                v9 = this.getStripOffsets();
                Intrinsics.checkNotNull(v9);
                offset = v9.get(index).intValue();
                v10 = this.getStripByteCounts();
                Intrinsics.checkNotNull(v10);
                byteCount = v10.get(index).intValue();
            }
            this.reader.setNextByte(offset);
            bytes = this.reader.readBytes(byteCount);
            v11 = this.decoder;
            Intrinsics.checkNotNull((Object)v11);
            tileOrStrip = v11.decode(bytes, this.reader.getByteReaderOrder());
            if (this.cache != null) {
                v12 = this.cache;
                Intrinsics.checkNotNull(v12);
                v12.put(index, tileOrStrip);
            } else {
                this.lastBlockIndex = index;
                this.lastBlock = tileOrStrip;
            }
        }
        Intrinsics.checkNotNull((Object)tileOrStrip);
        return tileOrStrip;
    }

    private final int getSampleByteSize(int sampleIndex) {
        List<Integer> bitsPerSample;
        List<Integer> list = bitsPerSample = this.getBitsPerSample();
        Intrinsics.checkNotNull(list);
        if (sampleIndex >= list.size()) {
            throw (Throwable)new TiffException("Sample index " + sampleIndex + " is out of range");
        }
        int bits = ((Number)bitsPerSample.get(sampleIndex)).intValue();
        if (bits % 8 != 0) {
            throw (Throwable)new TiffException("Sample bit-width of " + bits + " is not supported");
        }
        return bits / 8;
    }

    public final int getIntegerEntryValue(@NotNull FieldTagType fieldTagType) {
        Intrinsics.checkNotNullParameter((Object)((Object)fieldTagType), (String)"fieldTagType");
        return ((Number)this.getEntryValue(fieldTagType)).intValue();
    }

    public final void setUnsignedIntegerEntryValue(@NotNull FieldTagType fieldTagType, int value) {
        Intrinsics.checkNotNullParameter((Object)((Object)fieldTagType), (String)"fieldTagType");
        this.setEntryValue(fieldTagType, FieldType.SHORT, 1L, value);
    }

    @NotNull
    public final Number getNumberEntryValue(@NotNull FieldTagType fieldTagType) {
        Intrinsics.checkNotNullParameter((Object)((Object)fieldTagType), (String)"fieldTagType");
        return (Number)this.getEntryValue(fieldTagType);
    }

    public final void setUnsignedLongEntryValue(@NotNull FieldTagType fieldTagType, long value) {
        Intrinsics.checkNotNullParameter((Object)((Object)fieldTagType), (String)"fieldTagType");
        this.setEntryValue(fieldTagType, FieldType.LONG, 1L, value);
    }

    @Nullable
    public final String getStringEntryValue(@NotNull FieldTagType fieldTagType) {
        Intrinsics.checkNotNullParameter((Object)((Object)fieldTagType), (String)"fieldTagType");
        String value = null;
        List values = (List)this.getEntryValue(fieldTagType);
        if (values != null && !values.isEmpty()) {
            value = (String)values.get(0);
        }
        return value;
    }

    public final void setStringEntryValue(@NotNull FieldTagType fieldTagType, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)((Object)fieldTagType), (String)"fieldTagType");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        this.setEntryValue(fieldTagType, FieldType.ASCII, value.length() + 1, values);
    }

    @Nullable
    public final List<Integer> getIntegerListEntryValue(@NotNull FieldTagType fieldTagType) {
        Intrinsics.checkNotNullParameter((Object)((Object)fieldTagType), (String)"fieldTagType");
        return (List)this.getEntryValue(fieldTagType);
    }

    public final void setUnsignedIntegerListEntryValue(@NotNull FieldTagType fieldTagType, @NotNull List<Integer> value) {
        Intrinsics.checkNotNullParameter((Object)((Object)fieldTagType), (String)"fieldTagType");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.setEntryValue(fieldTagType, FieldType.SHORT, value.size(), value);
    }

    @Nullable
    public final Integer getMaxIntegerEntryValue(@NotNull FieldTagType fieldTagType) {
        Intrinsics.checkNotNullParameter((Object)((Object)fieldTagType), (String)"fieldTagType");
        Integer maxValue = null;
        List<Integer> values = this.getIntegerListEntryValue(fieldTagType);
        if (values != null) {
            maxValue = (Integer)CollectionsKt.max((Iterable)values);
        }
        return maxValue;
    }

    @Nullable
    public final List<Number> getNumberListEntryValue(@NotNull FieldTagType fieldTagType) {
        Intrinsics.checkNotNullParameter((Object)((Object)fieldTagType), (String)"fieldTagType");
        return (List)this.getEntryValue(fieldTagType);
    }

    @Nullable
    public final List<Long> getLongListEntryValue(@NotNull FieldTagType fieldTagType) {
        Intrinsics.checkNotNullParameter((Object)((Object)fieldTagType), (String)"fieldTagType");
        return (List)this.getEntryValue(fieldTagType);
    }

    public final void setUnsignedLongListEntryValue(@NotNull FieldTagType fieldTagType, @NotNull List<Long> value) {
        Intrinsics.checkNotNullParameter((Object)((Object)fieldTagType), (String)"fieldTagType");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.setEntryValue(fieldTagType, FieldType.LONG, value.size(), value);
    }

    private final <T> T getEntryValue(FieldTagType fieldTagType) {
        FileDirectoryEntry fileDirectoryEntry = this.fieldTagTypeMapping.get((Object)fieldTagType);
        Object object = fileDirectoryEntry != null ? fileDirectoryEntry.getValues() : null;
        if (object == null) {
            throw (Throwable)new TiffException("The entry value not found for " + (Object)((Object)fieldTagType) + " field tag");
        }
        return (T)object;
    }

    private final void setEntryValue(FieldTagType fieldTagType, FieldType fieldType, long typeCount, Object values) {
        FileDirectoryEntry entry = new FileDirectoryEntry(fieldTagType, fieldType, typeCount, values);
        this.addEntry(entry);
    }

    /*
     * WARNING - void declaration
     */
    private final int sum(List<Integer> values, int start, int end) {
        int sum = 0;
        int n = start;
        int n2 = end;
        while (n < n2) {
            void i;
            List<Integer> list = values;
            Intrinsics.checkNotNull(list);
            sum += ((Number)list.get((int)i)).intValue();
            ++i;
        }
        return sum;
    }

    private final List<Integer> createSingleIntegerList(int value) {
        ArrayList<Integer> valueList = new ArrayList<Integer>();
        valueList.add(value);
        return valueList;
    }

    private final List<Long> createSingleLongList(long value) {
        ArrayList<Long> valueList = new ArrayList<Long>();
        valueList.add(value);
        return valueList;
    }

    public final long size() {
        return 2 + this.entries.size() * 12 + 4;
    }

    public final long sizeWithValues() {
        long size = 6;
        for (FileDirectoryEntry entry : this.entries) {
            size += entry.sizeWithValues();
        }
        return size;
    }

    /*
     * Enabled aggressive block sorting
     */
    public FileDirectory(@NotNull LinkedHashSet<FileDirectoryEntry> entries, @NotNull ByteReader reader, boolean cacheData) {
        Integer pc;
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.entries = entries;
        this.reader = reader;
        this.fieldTagTypeMapping = new HashMap();
        this.lastBlockIndex = -1;
        for (FileDirectoryEntry entry : this.entries) {
            Map map = this.fieldTagTypeMapping;
            FieldTagType fieldTagType = entry.getFieldTag();
            FileDirectoryEntry fileDirectoryEntry = entry;
            Intrinsics.checkNotNullExpressionValue((Object)fileDirectoryEntry, (String)"entry");
            map.put(fieldTagType, fileDirectoryEntry);
        }
        this.setCache(cacheData);
        this.isTiled = this.getRowsPerStrip() == null;
        Integer n = pc = this.getPlanarConfiguration();
        int n2 = this.planarConfiguration = n != null ? n : 1;
        if (this.planarConfiguration != 1 && this.planarConfiguration != 2) {
            throw (Throwable)new TiffException("Invalid planar configuration: " + this.planarConfiguration);
        }
        Integer compression = this.getCompression();
        if (compression == null) {
            compression = 1;
        }
        Integer n3 = compression;
        int n4 = 1;
        if (n3 == n4) {
            this.decoder = new RawCompression();
            return;
        }
        n4 = 2;
        if (n3 == n4) {
            throw (Throwable)new TiffException("CCITT Huffman compression not supported: " + compression);
        }
        n4 = 3;
        if (n3 == n4) {
            throw (Throwable)new TiffException("T4-encoding compression not supported: " + compression);
        }
        n4 = 4;
        if (n3 == n4) {
            throw (Throwable)new TiffException("T6-encoding compression not supported: " + compression);
        }
        n4 = 5;
        if (n3 == n4) {
            this.decoder = new LZWCompression();
            return;
        }
        n4 = 6;
        if (n3 == n4) {
            throw (Throwable)new TiffException("JPEG compression not supported: " + compression);
        }
        n4 = 7;
        if (n3 == n4) {
            throw (Throwable)new TiffException("JPEG compression not supported: " + compression);
        }
        n4 = 8;
        if (n3 != n4) {
            n4 = 32946;
            if (n3 != n4) {
                n4 = 32773;
                if (n3 != n4) throw (Throwable)new TiffException("Unknown compression method identifier: " + compression);
                this.decoder = new PackbitsCompression();
                return;
            }
        }
        this.decoder = new DeflateCompression();
    }
}

