/*
 * Decompiled with CFR 0.152.
 */
package ai.active.fulfillment.webhook;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.security.crypto.codec.Hex;

public class WebhookUtil {
    private static final String SHA1 = "sha1=";
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";

    public static String generateSignature(String request, String secret) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
        SecretKeySpec signingKey = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), HMAC_SHA1_ALGORITHM);
        mac.init(signingKey);
        byte[] rawHmac = mac.doFinal(request.getBytes(StandardCharsets.UTF_8));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SHA1);
        stringBuilder.append(Hex.encode((byte[])rawHmac));
        return stringBuilder.toString();
    }
}

