/*
 * Decompiled with CFR 0.152.
 */
package ai.active.fulfillment.webhook.data.request.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum EventType {
    FULFILMENT("fulfilment"),
    WORKFLOW_VALIDATION("wf_validation"),
    WORKFLOW_CONNECTION("wf_connection"),
    WORKFLOW_PROMPT("wf_prompt"),
    WORKFLOW_UPDATE_VALIDATION("wf_u_validation"),
    WORKFLOW_UPDATE_CONNECTION("wf_u_connection");

    private static final Map<String, EventType> CONSTANTS;
    private String value;

    private EventType(String value) {
        this.value = value;
    }

    @JsonCreator
    public static EventType fromValue(String value) {
        EventType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    static {
        CONSTANTS = new HashMap<String, EventType>();
        for (EventType c : EventType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

