/*
 * Decompiled with CFR 0.152.
 */
package ai.active.fulfillment.webhook.data.response;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ButtonType {
    POSTBACK("postback"),
    WEBURL("weburl");

    private static final Map<String, ButtonType> CONSTANTS;
    private String value;

    private ButtonType(String value) {
        this.value = value;
    }

    @JsonCreator
    public static ButtonType fromValue(String value) {
        ButtonType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    static {
        CONSTANTS = new HashMap<String, ButtonType>();
        for (ButtonType c : ButtonType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

