/*
 * Decompiled with CFR 0.152.
 */
package ai.active.fulfillment.webhook.data.response;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum MessageType {
    TEXT("text"),
    LIST("list"),
    BUTTON("button"),
    CAROUSEL("carousel"),
    IMAGE("image"),
    VIDEO("video"),
    CUSTOM("custom"),
    MARKUP("markup");

    private static final Map<String, MessageType> CONSTANTS;
    private String value;

    private MessageType(String value) {
        this.value = value;
    }

    @JsonCreator
    public static MessageType fromValue(String value) {
        MessageType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    static {
        CONSTANTS = new HashMap<String, MessageType>();
        for (MessageType c : MessageType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

