/*
 * Decompiled with CFR 0.152.
 */
package ai.active.fulfillment.webhook.data.response;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum Status {
    SUCCESS("success"),
    FAILED("error"),
    TFA_PENDING("2faPending"),
    TFA_SUCCESS("2faSuccess"),
    TFA_FAILURE("2faFailure"),
    PENDING("pending"),
    LOGIN_PENDING("loginPending");

    private static final Map<String, Status> CONSTANTS;
    private String value;

    private Status(String value) {
        this.value = value;
    }

    @JsonCreator
    public static Status fromValue(String value) {
        Status constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    static {
        CONSTANTS = new HashMap<String, Status>();
        for (Status c : Status.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

