/*
 * Decompiled with CFR 0.152.
 */
package ai.ancf.lmos.arc.spring;

import ai.ancf.lmos.arc.agents.events.EventPublisher;
import ai.ancf.lmos.arc.agents.llm.ChatCompleter;
import ai.ancf.lmos.arc.agents.llm.ChatCompleterProvider;
import ai.ancf.lmos.arc.client.azure.AzureAIClient;
import ai.ancf.lmos.arc.client.azure.AzureClientConfig;
import ai.ancf.lmos.arc.client.ollama.OllamaClient;
import ai.ancf.lmos.arc.client.ollama.OllamaClientConfig;
import ai.ancf.lmos.arc.spring.AIClientConfig;
import ai.ancf.lmos.arc.spring.AIConfig;
import ai.ancf.lmos.arc.spring.ClientBuilder;
import com.azure.ai.openai.OpenAIAsyncClient;
import com.azure.ai.openai.OpenAIClientBuilder;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.credential.KeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.identity.DefaultAzureCredentialBuilder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@ConditionalOnMissingBean(value={ChatCompleterProvider.class})
@EnableConfigurationProperties(value={AIConfig.class})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\b\u0010\u0006\u001a\u00020\u0005H\u0007J\b\u0010\u0007\u001a\u00020\u0005H\u0003J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007\u00a8\u0006\u0010"}, d2={"Lai/ancf/lmos/arc/spring/ClientsConfiguration;", "", "<init>", "()V", "openAIAsyncClient", "Lai/ancf/lmos/arc/spring/ClientBuilder;", "openAIAsyncClientWithAzureCredentials", "ollamaClient", "chatCompleterProvider", "Lai/ancf/lmos/arc/agents/llm/ChatCompleterProvider;", "aiConfig", "Lai/ancf/lmos/arc/spring/AIConfig;", "clientBuilders", "", "eventPublisher", "Lai/ancf/lmos/arc/agents/events/EventPublisher;", "arc-spring-boot-starter"})
@SourceDebugExtension(value={"SMAP\nClientsConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientsConfiguration.kt\nai/ancf/lmos/arc/spring/ClientsConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1187#2,2:105\n1261#2,2:107\n1264#2:110\n1#3:109\n*S KotlinDebug\n*F\n+ 1 ClientsConfiguration.kt\nai/ancf/lmos/arc/spring/ClientsConfiguration\n*L\n91#1:105,2\n91#1:107,2\n91#1:110\n*E\n"})
public final class ClientsConfiguration {
    @Bean
    @ConditionalOnClass(value={OpenAIAsyncClient.class})
    @NotNull
    public final ClientBuilder openAIAsyncClient() {
        return ClientsConfiguration::openAIAsyncClient$lambda$1;
    }

    @Bean
    @ConditionalOnClass(value={OpenAIAsyncClient.class, DefaultAzureCredentialBuilder.class})
    @NotNull
    public final ClientBuilder openAIAsyncClientWithAzureCredentials() {
        return ClientsConfiguration::openAIAsyncClientWithAzureCredentials$lambda$2;
    }

    @Bean
    @ConditionalOnClass(value={OllamaClient.class})
    private final ClientBuilder ollamaClient() {
        return ClientsConfiguration::ollamaClient$lambda$3;
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    @NotNull
    public final ChatCompleterProvider chatCompleterProvider(@NotNull AIConfig aiConfig, @NotNull List<? extends ClientBuilder> clientBuilders, @Nullable EventPublisher eventPublisher) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)aiConfig, (String)"aiConfig");
        Intrinsics.checkNotNullParameter(clientBuilders, (String)"clientBuilders");
        Iterable $this$associate$iv = aiConfig.getClients();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            ChatCompleter chatCompleter;
            String string;
            AIClientConfig config;
            Map map;
            block3: {
                map = destination$iv$iv;
                config = (AIClientConfig)element$iv$iv;
                boolean bl = false;
                Iterable iterable2 = clientBuilders;
                string = config.getId();
                for (ClientBuilder it : iterable2) {
                    boolean bl2 = false;
                    ChatCompleter chatCompleter2 = it.build(config, eventPublisher);
                    if (chatCompleter2 == null) continue;
                    chatCompleter = chatCompleter2;
                    break block3;
                }
                chatCompleter = null;
            }
            if (chatCompleter == null) {
                throw new IllegalStateException(("Cannot build client for " + config + "!").toString());
            }
            Pair pair = TuplesKt.to((Object)string, chatCompleter);
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map clients = destination$iv$iv;
        return arg_0 -> ClientsConfiguration.chatCompleterProvider$lambda$7(clients, arg_0);
    }

    private static final ChatCompleter openAIAsyncClient$lambda$1(AIClientConfig config, EventPublisher eventPublisher) {
        String string;
        OpenAIAsyncClient openAIAsyncClient;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (!Intrinsics.areEqual((Object)config.getClient(), (Object)"azure") && !Intrinsics.areEqual((Object)config.getClient(), (Object)"openai")) {
            return null;
        }
        if (Intrinsics.areEqual((Object)config.getClient(), (Object)"openai") || config.getUrl() == null) {
            OpenAIClientBuilder openAIClientBuilder;
            OpenAIClientBuilder $this$openAIAsyncClient_u24lambda_u241_u24lambda_u240 = openAIClientBuilder = new OpenAIClientBuilder();
            boolean bl = false;
            if (config.getUrl() != null) {
                $this$openAIAsyncClient_u24lambda_u241_u24lambda_u240.endpoint(config.getUrl());
            }
            openAIAsyncClient = openAIClientBuilder.credential(new KeyCredential(config.getApiKey())).buildAsyncClient();
        } else if (config.getApiKey() != null) {
            openAIAsyncClient = new OpenAIClientBuilder().endpoint(config.getUrl()).credential((KeyCredential)new AzureKeyCredential(config.getApiKey())).buildAsyncClient();
        } else {
            return null;
        }
        OpenAIAsyncClient azureClient = openAIAsyncClient;
        String string2 = config.getModelName();
        String string3 = config.getUrl();
        if (string3 == null) {
            string3 = "";
        }
        if ((string = config.getApiKey()) == null) {
            string = "";
        }
        AzureClientConfig azureClientConfig = new AzureClientConfig(string2, string3, string);
        Intrinsics.checkNotNull((Object)azureClient);
        return (ChatCompleter)new AzureAIClient(azureClientConfig, azureClient, eventPublisher);
    }

    private static final ChatCompleter openAIAsyncClientWithAzureCredentials$lambda$2(AIClientConfig config, EventPublisher eventPublisher) {
        String string;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (!Intrinsics.areEqual((Object)config.getClient(), (Object)"azure")) {
            return null;
        }
        if (config.getUrl() == null || config.getApiKey() != null) {
            return null;
        }
        OpenAIAsyncClient azureClient = new OpenAIClientBuilder().credential((TokenCredential)new DefaultAzureCredentialBuilder().build()).endpoint(config.getUrl()).buildAsyncClient();
        String string2 = config.getModelName();
        String string3 = config.getUrl();
        if (string3 == null) {
            string3 = "";
        }
        if ((string = config.getApiKey()) == null) {
            string = "";
        }
        AzureClientConfig azureClientConfig = new AzureClientConfig(string2, string3, string);
        Intrinsics.checkNotNull((Object)azureClient);
        return (ChatCompleter)new AzureAIClient(azureClientConfig, azureClient, eventPublisher);
    }

    private static final ChatCompleter ollamaClient$lambda$3(AIClientConfig config, EventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (!Intrinsics.areEqual((Object)config.getClient(), (Object)"ollama")) {
            return null;
        }
        return (ChatCompleter)new OllamaClient(new OllamaClientConfig(config.getModelName(), config.getUrl()), eventPublisher);
    }

    private static final ChatCompleter chatCompleterProvider$lambda$7(Map $clients, String model) {
        String string;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$clients, (String)"$clients");
                string = model;
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                ChatCompleter chatCompleter = (ChatCompleter)$clients.get(it);
                string = chatCompleter;
                if (chatCompleter != null) break block3;
            }
            string = (ChatCompleter)CollectionsKt.first((Iterable)$clients.values());
        }
        return string;
    }
}

